/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.tests.be.generator;

import static org.junit.Assert.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.domain.OrderItem;
import de.itemis.qimpress.showcase.order_simulator.be.dto.Customer;
import de.itemis.qimpress.showcase.order_simulator.be.dto.ProductInfo;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.generator.order_processing.BufferedOrderProcessor;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;

/**
 * JUnit test class for
 * {@link OrdersJmsSender}
 * 
 * @author Wladimir Safonov
 *
 */
public class OrdersJmsSenderTest {

    private static final Logger LOG = Logger.getLogger(OrdersJmsSenderTest.class);
    
    private static BufferedOrderProcessor ORDERS_JMS_SENDER;
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }

        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        try {
            ORDERS_JMS_SENDER = (BufferedOrderProcessor) ctxt.getBean("orderJmsSender");
        } catch (BeansException e) {
            e.printStackTrace();
            fail("Failed to load OrdersJmsSender from the application context");
        }
        assertNotNull("Failed to load OrdersJmsSender from the application context: result is null", ORDERS_JMS_SENDER);
    }
    
    @Test
    public void testSendOrdersBatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testSendOrdersBatch()");
        }
        
        GlobalParameters params = new GlobalParameters();
        params.setOrdersBatchSize(1);
        
        Order order = new Order();
        order.setNumber("123");
        Customer customer = new Customer();
        customer.setCustomerNumber("456");
        order.setCustomer(customer);
        ProductInfo productInfo = new ProductInfo();
        productInfo.setProductCode("prod321");
        productInfo.setProductName("Joystick");
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setProduct(productInfo);
        orderItem.setQuantity(50);
        orderItem.setTotalPrice(new BigDecimal(33));
        orderItems.add(orderItem);
        order.setOrderItems(orderItems);
        order.setNumber("99");
        order.setTotalPrice(new BigDecimal(8888));
        order.setCreationDate(new Date());

        try {
            ORDERS_JMS_SENDER.process(order, params);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
        
    }

}
