/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.tests.be.generator;

import static org.junit.Assert.assertTrue;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.domain.OrderItem;
import de.itemis.qimpress.showcase.order_simulator.be.dto.Customer;
import de.itemis.qimpress.showcase.order_simulator.be.dto.ProductInfo;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.generator.order_processing.OrdersCsvWriter;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;

/**
 * @author Claudius Haecker
 *
 */
public class OrdersCsvWriterTest {

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOrderCsvWriter() throws ApplicationException {
        OrdersCsvWriter ordersCsvWriter = new OrdersCsvWriter();
        
        // init params only with output dir & items per file bound
        GlobalParameters params = new GlobalParameters();
        params.setOutputFolder("C:\\orders_output");
        params.setOrdersBatchSize(5);
        
        Order order = new Order();
        order.setNumber("123");
        Customer customer = new Customer();
        customer.setCustomerNumber("456");
        order.setCustomer(customer);
        ProductInfo productInfo = new ProductInfo();
        productInfo.setProductCode("prod321");
        productInfo.setProductName("Joystick");
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setProduct(productInfo);
        orderItem.setQuantity(50);
        orderItem.setTotalPrice(new BigDecimal(33));
        orderItems.add(orderItem);
        order.setOrderItems(orderItems);
        order.setNumber("99");
        order.setTotalPrice(new BigDecimal(8888));
        order.setCreationDate(new Date());
        ordersCsvWriter.process(order, params);
        ordersCsvWriter.flush();

        File fileLastSaved1 = ordersCsvWriter.getLastSavedFile();
        assertTrue(fileLastSaved1.exists());
        assertTrue(fileLastSaved1.length() > 130);
        assertTrue(fileLastSaved1.length() < 150);
        
        ordersCsvWriter.flush();
        File fileLastSaved2 = ordersCsvWriter.getLastSavedFile();
        assertTrue(fileLastSaved2.exists());
        assertTrue(fileLastSaved2.length() > 90);
        assertTrue(fileLastSaved2.length() < 100);
        assertTrue(!fileLastSaved1.getName().equals(fileLastSaved2.getName()));
        
    }
}
