/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.tests.be.generator;

import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.order_simulator.be.generator.OrderGeneratorJob;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.CustomerTypeParameters;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.TimeParameters;

/**
 * @author Wladimir Safonov
 *
 */
public class OrderGeneratorJobTest {

    private static final Logger LOG = Logger.getLogger(OrderGeneratorJobTest.class);

    private static OrderGeneratorJob ORDER_GENERATOR_JOB;

    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called initTestSuite()");
        }

        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        ORDER_GENERATOR_JOB = (OrderGeneratorJob) ctxt.getBean("orderGeneratorJob");
        assertNotNull("Failed to load ServiceManager", ORDER_GENERATOR_JOB);
    }

    @Test
    public void testGeneratorJob() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called testGeneratorJob()");
        }

        // create test parameters
        Map<String, CustomerTypeParameters> typeSpecificsParameters = new HashMap<String, CustomerTypeParameters>(3);
        typeSpecificsParameters.put("private", new CustomerTypeParameters("private", 1, 5, 1, 5));
        typeSpecificsParameters.put("business", new CustomerTypeParameters("business", 5, 10, 5, 10));
        typeSpecificsParameters.put("reseller", new CustomerTypeParameters("reseller", 10, 100, 10, 20));
        TimeParameters timeParameters = new TimeParameters();
        timeParameters.setStartTimeOfGenerator(new Date());
        GlobalParameters generatorParameters = new GlobalParameters("C:\\orders_output", 1, 1.0f, 1.0f,
                typeSpecificsParameters, timeParameters);

        ORDER_GENERATOR_JOB.execute(generatorParameters);
    }
}
