/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.tests.be.generator;

import static org.junit.Assert.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.order_simulator.be.dao.OrderDao;
import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.domain.OrderItem;
import de.itemis.qimpress.showcase.order_simulator.be.dto.Customer;
import de.itemis.qimpress.showcase.order_simulator.be.dto.CustomerCategory;
import de.itemis.qimpress.showcase.order_simulator.be.dto.CustomerType;
import de.itemis.qimpress.showcase.order_simulator.be.dto.ProductInfo;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;

/**
 * Unit test class for {@link OrderDao}.
 * 
 * @author Wladimir Safonov
 * 
 */
public class OrderDaoTest {

    private static final Logger LOG = Logger.getLogger(OrderDaoTest.class);

    private static OrderDao ORDER_DAO;

    /**
     * Use this method to create a test related ID prefix. This might be used to
     * build artificial DB-Id's using the name of the current test.
     * 
     * @return The canonical name if this class, striped to a size of max 200
     *         chars
     */
    private static final String getTestRelatedUniqueId() {
        return OrderDaoTest.class.getCanonicalName().substring(0,
                Math.min(199, OrderDaoTest.class.getCanonicalName().length()));
    }

    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }

        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        try {
            ORDER_DAO = (OrderDao) ctxt.getBean("orderDao");
        } catch (BeansException e) {
            fail("Failed to load OrderDao");
        }
    }

    @Test
    public void testSaveOrder() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testSaveOrder()");
        }

        Order order = new Order();
        order.setNumber("123");

        // Initialize a new customer stub
        Customer customer = new Customer();
        customer.setCustomerNumber("456");
        final CustomerCategory customerCategory = new CustomerCategory();
        customerCategory.setCustomerCategoryKey(getTestRelatedUniqueId() + "__dummy__CustomerCategory_1");
        customer.setCustomerCategory(customerCategory);
        customer.setCustomerType(new CustomerType(getTestRelatedUniqueId() + "__dummy__CustomerType_1",
                getTestRelatedUniqueId() + "_TYPE_NAME1"));

        order.setCustomer(customer);
        ProductInfo productInfo = new ProductInfo();
        productInfo.setProductCode("prod321");
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setProduct(productInfo);
        orderItem.setQuantity(50);
        orderItem.setTotalPrice(new BigDecimal(33));
        orderItems.add(orderItem);
        order.setOrderItems(orderItems);
        order.setNumber("OR0000099");
        order.setTotalPrice(new BigDecimal(8888));
        order.setCreationDate(new Date());

        try {
            ORDER_DAO.save(order);
        } catch (DaoException e) {
            e.printStackTrace();
            fail("Failed to save Order");
        }
    }

    @Test
    public void testGetNextOrderNumber() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetNextOrderNumber()");
        }

        Long nextOrderNumber1 = null, nextOrderNumber2 = null;
        try {
            nextOrderNumber1 = ORDER_DAO.getNextOrderNumber();
            nextOrderNumber2 = ORDER_DAO.getNextOrderNumber();
        } catch (DaoException e) {
            e.printStackTrace();
            fail("Failed to get next order number");
        }
        assertNotNull("Generated order number is null", nextOrderNumber1);
        assertNotNull("Generated order number is null", nextOrderNumber2);
        assertFalse("Generated order numbers are equal", nextOrderNumber1.equals(nextOrderNumber2));
    }
}
