/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.webservices.messages;

import de.itemis.qimpress.showcase.order_simulator.be.dto.Country;
import de.itemis.qimpress.showcase.order_simulator.be.dto.CustomerCategory;
import de.itemis.qimpress.showcase.order_simulator.be.dto.CustomerType;

/**
 * Filter object used in the CRM.QueryCustomer WebService request.
 * 
 * @author Wladimir Safonov
 *
 */
public class CustomerFilter {

    private String customerNamePattern;
    private String customerNumberPattern;
    private CustomerCategory categoryFilter;
    private CustomerType typeFilter;
    private Country deliveryCountry;
    private Country invoiceCountry;
    
    /**
     * @return the customerNamePattern
     */
    public String getCustomerNamePattern() {
        return customerNamePattern;
    }
    
    /**
     * @return the customerNumberPattern
     */
    public String getCustomerNumberPattern() {
        return customerNumberPattern;
    }

    /**
     * @param customerNumberPattern the customerNumberPattern to set
     */
    public void setCustomerNumberPattern(String customerNumberPattern) {
        this.customerNumberPattern = customerNumberPattern;
    }

    /**
     * @return the categoryFilter
     */
    public CustomerCategory getCategoryFilter() {
        return categoryFilter;
    }

    /**
     * @param categoryFilter the categoryFilter to set
     */
    public void setCategoryFilter(CustomerCategory categoryFilter) {
        this.categoryFilter = categoryFilter;
    }

    /**
     * @return the typeFilter
     */
    public CustomerType getTypeFilter() {
        return typeFilter;
    }

    /**
     * @param typeFilter the typeFilter to set
     */
    public void setTypeFilter(CustomerType typeFilter) {
        this.typeFilter = typeFilter;
    }

    /**
     * @return the deliveryCountry
     */
    public Country getDeliveryCountry() {
        return deliveryCountry;
    }

    /**
     * @param deliveryCountry the deliveryCountry to set
     */
    public void setDeliveryCountry(Country deliveryCountry) {
        this.deliveryCountry = deliveryCountry;
    }

    /**
     * @return the invoiceCountry
     */
    public Country getInvoiceCountry() {
        return invoiceCountry;
    }

    /**
     * @param invoiceCountry the invoiceCountry to set
     */
    public void setInvoiceCountry(Country invoiceCountry) {
        this.invoiceCountry = invoiceCountry;
    }

    /**
     * @param customerNamePattern the customerNamePattern to set
     */
    public void setCustomerNamePattern(String customerNamePattern) {
        this.customerNamePattern = customerNamePattern;
    }
}
