/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager.reports;

import java.math.BigDecimal;

/**
 * Holder class for sales summary per customer. Normally it is used 
 * in reports covering certain period of time.
 * 
 * @author Wladimir Safonov
 *
 */
public class SalesPerCustomerSummary {

    /** number of the customer in this summary */
    private String customerNumber;
    /** name of the customer in this summary */
    private String customerName;
    /** category of the customer in the summary */
    private String customerCategory;
    /** type of the customer in the summary */
    private String customerType;
    /** number of orders for the customer */
    private int ordersNumber;
    /** sales volume for the customer */
    private BigDecimal salesVolume;
    
    /**
     * @return the customerNumber
     */
    public String getCustomerNumber() {
        return customerNumber;
    }
    
    /**
     * @param customerNumber the customerNumber to set
     */
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    /**
     * @return the customerName
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * @param customerName the customerName to set
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * @return the customerCategory
     */
    public String getCustomerCategory() {
        return customerCategory;
    }

    /**
     * @param customerCategory the customerCategory to set
     */
    public void setCustomerCategory(String customerCategory) {
        this.customerCategory = customerCategory;
    }

    /**
     * @return the customerType
     */
    public String getCustomerType() {
        return customerType;
    }

    /**
     * @param customerType the customerType to set
     */
    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    /**
     * @return the ordersNumber
     */
    public int getOrdersNumber() {
        return ordersNumber;
    }

    /**
     * @param ordersNumber the ordersNumber to set
     */
    public void setOrdersNumber(int ordersNumber) {
        this.ordersNumber = ordersNumber;
    }

    /**
     * @return the salesVolume
     */
    public BigDecimal getSalesVolume() {
        return salesVolume;
    }

    /**
     * @param salesVolume the salesVolume to set
     */
    public void setSalesVolume(BigDecimal salesVolume) {
        this.salesVolume = salesVolume;
    }
}
