/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager.model;

import java.util.Map;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * Class representing general configuration data for the generator.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "global_parameters")
public class GlobalParameters {

    /** primary key */
    private Long id;

    /** output directory for generated CSV files */
    private String outputFolder;
    /** orders number threshold for batch processing */
    private int ordersBatchSize;
    /** order generation probability for each generator run */
    private float orderProbability;
    /** time interval between generator runs (in seconds) */
    private float orderInterval;
    /** specific generation parameters for customer types */
    private Map<String, CustomerTypeParameters> typeSpecificParameters;
    /** generator time mode parameters */
    private TimeParameters timeParameters;

    /**
     * Empty constructor
     */
    public GlobalParameters() {
        super();
        // TODO Auto-generated constructor stub
    }

    /**
     * Initializes properties with the given values.
     * 
     * @param outputFolder output directory for generated CSV files
     * @param ordersBatchSize orders number threshold for batch processing
     * @param orderProbability order generation probability for each generator run
     * @param orderInterval time interval between generator runs (in seconds)
     * @param typeSpecificParameters specific generation parameters for customer types
     */
    public GlobalParameters(String outputFolder, int ordersBatchSize, float orderProbability, float orderInterval,
            Map<String, CustomerTypeParameters> typeSpecificParameters, TimeParameters timeParameters) {
        this();
        this.outputFolder = outputFolder;
        this.ordersBatchSize = ordersBatchSize;
        this.orderProbability = orderProbability;
        this.orderInterval = orderInterval;
        this.typeSpecificParameters = typeSpecificParameters;
        this.timeParameters = timeParameters;
    }

    /**
     * @return the primary key
     */
    @Id
    @GeneratedValue
    @Column(name = "global_parameters_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * Getter for the output directory for generated CSV files
     * 
     * @return the outputFolder
     */
    @Column(name = "output_folder")
    public String getOutputFolder() {
        return outputFolder;
    }

    /**
     * Setter for the output directory for generated CSV files
     * 
     * @param outputFolder the outputFolder to set
     */
    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    /**
     * Getter for the orders number threshold for batch processing
     * 
     * @return the ordersBatchSize
     */
    @Column(name = "orders_batch_size")
    public int getOrdersBatchSize() {
        return ordersBatchSize;
    }

    /**
     * Setter for the orders number threshold for batch processing
     * 
     * @param ordersBatchSize the ordersBatchSize to set
     */
    public void setOrdersBatchSize(int ordersBatchSize) {
        this.ordersBatchSize = ordersBatchSize;
    }

    /**
     * Getter for the order generation probability for each generator run
     * 
     * @return the orderProbability
     */
    @Column(name = "order_probability")
    public float getOrderProbability() {
        return orderProbability;
    }

    /**
     * Setter for the order generation probability for each generator run
     * 
     * @param orderProbability the orderProbability to set
     */
    public void setOrderProbability(float orderProbability) {
        this.orderProbability = orderProbability;
    }

    /**
     * Getter for the time interval between generator runs in seconds
     * 
     * @return the orderInterval
     */
    @Column(name = "order_interval")
    public float getOrderInterval() {
        return orderInterval;
    }

    /**
     * Setter for the time interval between generator runs in seconds
     * 
     * @param orderInterval the orderInterval to set
     */
    public void setOrderInterval(float orderInterval) {
        this.orderInterval = orderInterval;
    }

    /**
     * Getter for the specific generation parameters for customer types
     * 
     * @return the typeSpecificParameters
     */
    @OneToMany(fetch = FetchType.EAGER)
    @JoinColumn(name = "global_parameters_id")
    @MapKey(name = "customerTypeName")
    public Map<String, CustomerTypeParameters> getTypeSpecificParameters() {
        return typeSpecificParameters;
    }

    /**
     * Setter for the specific generation parameters for customer types
     * 
     * @param typeSpecificParameters the typeSpecificParameters to set
     */
    public void setTypeSpecificParameters(Map<String, CustomerTypeParameters> typeSpecificParameters) {
        this.typeSpecificParameters = typeSpecificParameters;
    }

    /**
     * Getter for the generator time mode parameters.
     * 
     * @return the timeParameters
     */
    @Transient
    public TimeParameters getTimeParameters() {
        return timeParameters;
    }

    /**
     * Setter for the generator time mode parameters.
     * 
     * @param timeParameters the timeParameters to set
     */
    public void setTimeParameters(TimeParameters timeParameters) {
        this.timeParameters = timeParameters;
    }

}
