/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Class representing customer type specific parameters for the order generator.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "customer_type_parameters")
public class CustomerTypeParameters {
    
    /** primary key */
    private Long id;
    
    /** minimal product quantity per order item */
    private int minQuantityPerItem;
    /** maximal product quantity per order item */
    private int maxQuantityPerItem;
    /** minimal number of items per order */
    private int minItemsPerOrder;
    /** maximal number of items per order */
    private int maxItemsPerOrder;
    /** customer type name */
    private String customerTypeName;

    /**
     * empty constructor
     */
    public CustomerTypeParameters() {
    }

    public CustomerTypeParameters(String customerTypeName, int minQuantityPerItem, int maxQuantityPerItem, 
            int minItemsPerOrder, int maxItemsPerOrder) {
        this.customerTypeName = customerTypeName;
        this.minQuantityPerItem = minQuantityPerItem;
        this.maxQuantityPerItem = maxQuantityPerItem;
        this.minItemsPerOrder = minItemsPerOrder;
        this.maxItemsPerOrder = maxItemsPerOrder;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "customer_type_parameters_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * Getter for the minimal product quantity per order item
     * 
     * @return the minQuantityPerItem
     */
    @Column(name = "min_quantity_per_item")
    public int getMinQuantityPerItem() {
        return minQuantityPerItem;
    }

    /**
     * Setter for the minimal product quantity per order item
     * 
     * @param minQuantityPerItem the minQuantityPerItem to set
     */
    public void setMinQuantityPerItem(int minQuantityPerItem) {
        this.minQuantityPerItem = minQuantityPerItem;
    }

    /**
     * Getter for the maximal product quantity per order item
     * 
     * @return the maxQuantityPerItem
     */
    @Column(name = "max_quantity_per_item")
    public int getMaxQuantityPerItem() {
        return maxQuantityPerItem;
    }

    /**
     * Setter for the maximal product quantity per order item
     * 
     * @param maxQuantityPerItem the maxQuantityPerItem to set
     */
    public void setMaxQuantityPerItem(int maxQuantityPerItem) {
        this.maxQuantityPerItem = maxQuantityPerItem;
    }

    /**
     * Getter for the minimal number of items per order
     * 
     * @return the minItemsPerOrder
     */
    @Column(name = "min_items_per_order")
    public int getMinItemsPerOrder() {
        return minItemsPerOrder;
    }

    /**
     * Setter for the minimal number of items per order
     * 
     * @param minItemsPerOrder the minItemsPerOrder to set
     */
    public void setMinItemsPerOrder(int minItemsPerOrder) {
        this.minItemsPerOrder = minItemsPerOrder;
    }

    /**
     * Getter for the maximal number of items per order
     * 
     * @return the maxItemsPerOrder
     */
    @Column(name = "max_items_per_order")
    public int getMaxItemsPerOrder() {
        return maxItemsPerOrder;
    }

    /**
     * Setter for the maximal number of items per order
     * 
     * @param maxItemsPerOrder the maxItemsPerOrder to set
     */
    public void setMaxItemsPerOrder(int maxItemsPerOrder) {
        this.maxItemsPerOrder = maxItemsPerOrder;
    }

    /**
     * Getter for the customer type name
     * 
     * @return the customerTypeName
     */
    @Column(name = "customer_type_name")
    public String getCustomerTypeName() {
        return customerTypeName;
    }

    /**
     * Setter for the customer type name
     * 
     * @param customerTypeName the customerTypeName to set
     */
    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }

}
