/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;

/**
 * @author Wladimir Safonov
 *
 */
public class GlobalParametersDaoImpl extends HibernateDaoSupport implements GlobalParametersDao {

    private static final Logger LOG = Logger.getLogger(GlobalParametersDaoImpl.class);
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.manager.dao.GlobalParametersDao#getAll()
     */
    /* @Override */
    public List<GlobalParameters> getAll() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called getAll()");
        }
        
        List<GlobalParameters> globalParameterList = null;
        try {
            globalParameterList = getHibernateTemplate().find("from GlobalParameters");
        } catch (DataAccessException e) {
            LOG.error("Failed to load the list of GlobalParameters", e);
            throw new DaoException();
        }
        return globalParameterList;
    }

    /* @Override */
    public void save(GlobalParameters globalParameters) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called save()");
        }
        
        try {
            getHibernateTemplate().saveOrUpdate(globalParameters);
        } catch (DataAccessException e) {
            LOG.error("Failed to save GlobalParametes", e);
            throw new DaoException();
        }
    }

}
