/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * Allows to locate the instance of the 
 * {@link de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager}
 * for use in the frontend.
 * 
 * @author Wladimir Safonov
 *
 */
public final class ServiceLocator {

    // ServiceLocator logger
    private static final Logger LOG = Logger.getLogger(ServiceLocator.class);

    // ServiceLocator singleton instance
    private static ServiceLocator self;

    // Spring application context with the OrderSimulatorManager service instance
    private ApplicationContext appContext;

    /**
     * Instantiates application context
     */
    private ServiceLocator() {
        LOG.info("Creating ApplicationContext");
        appContext = new ClassPathXmlApplicationContext("applicationContext.xml");
    }

    /**
     * Gets the singleton instance of the this ServiceLocator
     * 
     * @return ServiceLocator singleton instance
     */
    public static ServiceLocator getInstance() {
        if (self == null) {
            self = new ServiceLocator();
        }
        return self;
    }

    private Object getService(String serviceObjectName) throws NamingException {
        Object serviceObj = appContext.getBean(serviceObjectName);
        if (serviceObj == null) {
            String errMsg = "Service object '" + serviceObjectName + "' not found in the context";
            LOG.error(errMsg);
            throw new NamingException(errMsg);
        }
        return serviceObj;
    }

    /**
     * Locates and returns the singleton instance of the 
     * {@link OrderSimulatorManager}
     *  
     * @return singleton instance of the {@link OrderSimulatorManager}
     */
    public OrderSimulatorManager getOrderSimulatorManager() {
        try {
            return (OrderSimulatorManager) this.getService("orderSimulatorManager");
        } catch (NamingException e) {
            LOG.error("Failed to locate OrderSimulatorManager in the application context");
            throw new Error("Failed to locate OrderSimulatorManager in the application context", e);
        }
    }

    /**
     * Locates and returns the singleton instance of the 
     * {@link OrderReportingManager}
     * in the Spring application context by its name.
     * 
     * @return singleton instance of the {@link OrderReportingManager}
     */
    public OrderReportingManager getOrderReportingManager() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getOrderReportingManager");
        }
        try {
            return (OrderReportingManager) this.getService("orderReportingManager");
        } catch (NamingException e) {
            LOG.error("Failed to locate OrderReportingManager in the application context");
            throw new Error("Failed to locate OrderReportingManager in the application context", e);
        }
    }
}
