/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;
import de.itemis.qimpress.showcase.order_simulator.be.generator.GeneratorManager;
import de.itemis.qimpress.showcase.order_simulator.be.manager.dao.GlobalParametersDao;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.TimeParameters;

/**
 * @author Wladimir Safonov
 *
 */
public class OrderSimulatorManagerImpl implements OrderSimulatorManager {

    private static final Logger LOG = Logger.getLogger(OrderSimulatorManagerImpl.class);

    // generator control interface
    private GeneratorManager generatorManager;

    // DAO for parameters
    private GlobalParametersDao globalParametersDao;

    /**
     * @param generatorManager the generatorManager to set
     */
    public void setGeneratorManager(GeneratorManager generatorManager) {
        this.generatorManager = generatorManager;
    }

    /**
     * @param globalParametersDao the globalParametersDao to set
     */
    public void setGlobalParametersDao(GlobalParametersDao globalParametersDao) {
        this.globalParametersDao = globalParametersDao;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager#isOrderGeneratorRunning()
     */
    /* @Override */
    public boolean isOrderGeneratorRunning() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called isOrderGeneratorRunning()");
        }

        return generatorManager.isOrderGeneratorRunning();
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager#loadOrderGeneratorParameters()
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public GlobalParameters loadOrderGeneratorParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called loadOrderGeneratorParameters()");
        }

        List<GlobalParameters> globalParametersList = null;
        GlobalParameters globalParameters = null;
        try {
            globalParametersList = globalParametersDao.getAll();
        } catch (DaoException e) {
            // fail silently
            return null;
        }
        if (globalParametersList.size() >= 1) {
            // currently only one record expected -> take first
            globalParameters = globalParametersList.get(0);
        }
        return globalParameters;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager#saveOrderGeneratorParameters(de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters)
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED)
    public boolean saveOrderGeneratorParameters(GlobalParameters parameters) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called saveOrderGeneratorParameters()");
        }

        // stop generator
        //        boolean generatorWasRunning = isOrderGeneratorRunning();
        //        if (generatorWasRunning) {
        //            stopOrderGenerator();
        //        }

        // only saving parameters without generator restart
        // TODO: review GlobalParameters saving action
        try {
            globalParametersDao.save(parameters);
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }

        //        if (generatorWasRunning) {
        //            startOrderGenerator(parameters);
        //        }
        return true;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager#startOrderGenerator(de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters)
     */
    /* @Override */
    public boolean startOrderGenerator(TimeParameters timeParameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called startOrderGenerator()");
        }

        // load order generation parameters 
        GlobalParameters globalParameters = this.loadOrderGeneratorParameters();
        // set time parameters
        globalParameters.setTimeParameters(timeParameters);

        return generatorManager.startOrderGenerator(globalParameters);
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager#stopOrderGenerator()
     */
    /* @Override */
    public boolean stopOrderGenerator() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called startOrderGenerator()");
        }

        return generatorManager.stopOrderGenerator();
    }

}
