/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager;

import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.TimeParameters;

/**
 * Configuration and controlling interface for the Order Simulator
 * application. Allows to load/save generator parameters and
 * to start/stop the order generator with the given time mode parameters.
 * 
 * @author Wladimir Safonov
 *
 */
public interface OrderSimulatorManager {

    /**
     * Starts the order generator with the given parameters.
     * 
     * @param parameters order generations parameters
     * @return true if succeeded
     */
    public boolean startOrderGenerator(TimeParameters parameters);
    
    /**
     * Stops the order generator
     * 
     * @return true if succeeded
     * @throws ApplicationException 
     */
    public boolean stopOrderGenerator() throws ApplicationException;
    
    /**
     * Checks the status of the order generator.
     * 
     * @return true if the order generator is running
     */
    public boolean isOrderGeneratorRunning();
    
    /**
     * Loads parameters of the order generator.
     * 
     * @return order generation parameters
     */
    public GlobalParameters loadOrderGeneratorParameters();

    /**
     * Saves order generation parameters. If the order generator is running
     * at the moment, restarts with the new parameters.
     * 
     * @param parameters order generation parameters
     * @return true if succeeded
     * @throws ApplicationException 
     */
    public boolean saveOrderGeneratorParameters(GlobalParameters parameters) throws ApplicationException;
    
}
