/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.manager;

import java.util.Date;
import java.util.List;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.reports.SalesPerCustomerSummary;

/**
 * Reporting functionality interface for the Order Simulator application.
 * Allows to retrieve different kinds of summarized data for the
 * generated orders like order numbers and sales volume per customer.
 * 
 * @author Wladimir Safonov
 *
 */
public interface OrderReportingManager {

    /**
     * Calculates data for a sales-per-customer report for the given time period.
     * Customer category and type can be used to restrict customer selection.
     * All given <code>Date</code> objects are interpreted as dates only and define
     * a closed-end date interval for orders selection.
     * 
     * @param from beginning date for the orders selection
     * @param till ending date for the orders selection
     * @param customerCategory only customer of this category will be selected
     * @param customerType only customers of this type will be selected
     * @return list of {@link SalesPerCustomerSummary sales per customer} summaries
     */
    List<SalesPerCustomerSummary> calculateSalesPerCustomer(Date from, Date till, 
            String customerCategory, String customerType);
    
    
    /**
     * Retrieves a list of all orders for a specific customer and date interval.
     * For the given interval <code>Date</code> bounds, the date parts are 
     * used to calculate a closed-end interval for those dates.
     * 
     * @param customerNumber number of the customer to find the orders for
     * @param from beginning date for the orders selection
     * @param till ending date for the orders selection
     * @return list of orders for the given customer and date interval
     */
    List<Order> getOrdersForCustomerAndInterval(String customerNumber, Date from, Date till) throws ApplicationException;
    
}
