/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.generator.order_processing;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.order_simulator.be.dao.OrderDao;
import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;

/**
 * Implementation of the {@link OrderProcessor} for storing generated orders
 * in the database.
 * 
 * @author Wladimir Safonov
 *
 */
public class OrderDBWriter implements OrderProcessor {

    private static final Logger LOG = Logger.getLogger(OrderDBWriter.class);
    
    private OrderDao orderDao;
    
    /**
     * @param orderDao the orderDao to set
     */
    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_shipment_generator.be.generator.order_processing.OrderProcessor#process(de.itemis.qimpress.showcase.order_shipment_generator.be.domain.Order, de.itemis.qimpress.showcase.order_shipment_generator.be.configurator.model.GlobalParameters)
     */
    /* @Override */
    public void process(Order newOrder, GlobalParameters generatorParams) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> process()");
        }
        
        try {
            orderDao.save(newOrder);
        } catch (DaoException e) {
            LOG.error("Failed to save generated Order", e);
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        
    }

}
