/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.generator.order_processing;

import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;

/**
 * Extension of the 
 * {@link de.itemis.qimpress.showcase.order_simulator.be.generator.order_processing.OrderProcessor}
 * interface, which represents a buffered 
 * {@link de.itemis.qimpress.showcase.order_simulator.be.domain.Order}
 * processor. Additionally allows to flush the orders buffer
 * in order to process collected orders immediately at a user request.
 * 
 * @author Wladimir Safonov
 *
 */
public interface BufferedOrderProcessor extends OrderProcessor {

    /**
     * Flush the orders buffer and process collected orders immediately.
     * @throws ApplicationException 
     * 
     */
    public void flush() throws ApplicationException;
    
}
