/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.generator;

import java.text.DecimalFormat;
import java.text.NumberFormat;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.order_simulator.be.dao.OrderDao;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;

/**
 * Implementation of the {@link OrderNumberGenerator} interface, 
 * retrieving next order number from the database sequence and formatting
 * the number as follows: OR000000000.
 * 
 * @author Wladimir Safonov
 *
 */
public class OrderNumberGeneratorImpl implements OrderNumberGenerator {

    private static final Logger LOG = Logger.getLogger(OrderNumberGeneratorImpl.class);
    
    private static final NumberFormat ORDER_NUMBER_FORMAT = new DecimalFormat("000000000");

    /** OrderDao for retrieving order numbers */
    private OrderDao orderDao;
    
    /**
     * @param orderDao the orderDao to set
     */
    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_shipment_generator.be.generator.OrderNumberGenerator#generateNextOrderNumber()
     */
    /* @Override */
    public String generateNextOrderNumber() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> generateNextOrderNumber()");
        }
        
        Long nextOrderNumber;
        try {
            nextOrderNumber = orderDao.getNextOrderNumber();
        } catch (DaoException e) {
            LOG.error("Failed to generate order number", e);
            return null;
        }
        return formatOrderNumber(nextOrderNumber);
    }

    private String formatOrderNumber(Long orderNumber) {
        return "OR" + ORDER_NUMBER_FORMAT.format(orderNumber);
    }

}
