/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.generator;

import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;

/**
 * Generator control interface. Allows to start/stop the generator
 * and to get its current status.
 * 
 * @author Wladimir Safonov
 *
 */
public interface GeneratorManager {

    /**
     * Starts the order generator with the given parameters.
     * 
     * @param parameters order generations parameters
     * @return true if succeeded
     */
    public boolean startOrderGenerator(GlobalParameters parameters);
    
    /**
     * Stops the order generator
     * 
     * @return true if succeeded
     * @throws ApplicationException 
     */
    public boolean stopOrderGenerator() throws ApplicationException;
    
    /**
     * Checks the status of the order generator.
     * 
     * @return true if the order generator is running
     */
    public boolean isOrderGeneratorRunning();
    
}
