/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Each object of this class holds a type customers can be categorized in.
 * @author Claudius Haecker
 *
 */
public class CustomerType implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 4504718052533111168L;
    private String customerTypeId;
    private String customerTypeName;
    private String customerTypeKey;
    private Date dateCreated;
    private Date lastModified;

    public CustomerType() {
    }

    public CustomerType(String customerTypeId, String customerTypeName, String customerTypeKey, Date dateCreated,
            Date lastModified) {
        this.customerTypeId = customerTypeId;
        this.customerTypeName = customerTypeName;
        this.customerTypeKey = customerTypeKey;
        this.dateCreated = dateCreated;
        this.lastModified = lastModified;
    }

    /**
     * Creates a new CustomerType based on the given technical Id and the CustomerTypeName. 
     *  
     * @param customerTypeId
     * @param customerTypeName
     */
    public CustomerType(String customerTypeId, String customerTypeName) {
        this(customerTypeId, customerTypeName, null, null, null);
    }

    public String getCustomerTypeId() {
        return customerTypeId;
    }

    public void setCustomerTypeId(String customerTypeId) {
        this.customerTypeId = customerTypeId;
    }

    public String getCustomerTypeName() {
        return customerTypeName;
    }

    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }

    public String getCustomerTypeKey() {
        return customerTypeKey;
    }

    public void setCustomerTypeKey(String customerTypeKey) {
        this.customerTypeKey = customerTypeKey;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastModified() {
        return lastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setLastModified(Date dateLastModified) {
        this.lastModified = dateLastModified;
    }

}
