/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Each object of this class holds a category customers can be ranked in.
 * @author Claudius Haecker
 *
 */
public class CustomerCategory implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -6782186938078424230L;
    private Date dateCreated;
    private Date lastModified;
    private String customerCategoryName;
    private String customerCategoryKey;
    private String customerCategoryId;

    public CustomerCategory(String customerCategoryName, String customerCategoryKey) {
        super();
        this.customerCategoryName = customerCategoryName;
        this.customerCategoryKey = customerCategoryKey;
    }

    public CustomerCategory(String customerCategoryId, String customerCategoryName, String customerCategoryKey,
            Date dateCreated, Date lastModified) {
        this.dateCreated = dateCreated;
        this.lastModified = lastModified;
        this.customerCategoryName = customerCategoryName;
        this.customerCategoryKey = customerCategoryKey;
        this.customerCategoryId = customerCategoryId;
    }

    public CustomerCategory() {
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastModified() {
        return lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getCustomerCategoryName() {
        return customerCategoryName;
    }

    public void setCustomerCategoryName(String customerCategoryName) {
        this.customerCategoryName = customerCategoryName;
    }

    public String getCustomerCategoryKey() {
        return customerCategoryKey;
    }

    public void setCustomerCategoryKey(String customerCategoryKey) {
        this.customerCategoryKey = customerCategoryKey;
    }

    public String getCustomerCategoryId() {
        return customerCategoryId;
    }

    public void setCustomerCategoryId(String customerCategoryId) {
        this.customerCategoryId = customerCategoryId;
    }
}
