/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Each object of this class holds all information about a specific custormer
 * @author Claudius Haecker
 */
public class Customer implements Serializable {

    /** see interface Serializable */
    private static final long serialVersionUID = -6625421023512386063L;

    /** full name of the person or company*/
    private String name;
    /** the customer number is used by humans (e.g. staffer, customer) while customerId is database internal*/
    private String customerNumber;
    /** anything that doesn't fit in other address columns*/
    private String deliveryAddressField2;
    /** anything that doesn't fit in other address columns*/
    private String deliveryAddressField3;
    /** anything that doesn't fit in other address columns*/
    private String deliveryAddressField1;
    /** street name*/
    private String deliveryAddressStreet;
    /** house number*/
    private String deliveryAddressStreetNumber;
    /** code for the city*/
    private String deliveryAddressZipCode;
    /** name of the town*/
    private String deliveryAddressCity;
    /** can be determined with http://www.togis.com/addressGeodecoder*/
    private double deliveryAddressLongitude;
    /** can be determined with http://www.togis.com/addressGeodecoder*/
    private double deliveryAddressLatitude;
    /** anything that doesn't fit in other address columns*/
    private String invoiceAddressField1;
    /** anything that doesn't fit in other address columns*/
    private String invoiceAddressField2;
    /** anything that doesn't fit in other address columns*/
    private String invoiceAddressField3;
    /** street name*/
    private String invoiceAddressStreet;
    /** house number*/
    private String invoiceAddressStreetNumber;
    /** code for the city*/
    private String invoiceAddressZipCode;
    /** name of the town*/
    private String invoiceAddressCity;
    /** anything that doesn't fit in other table columns*/
    private String commentary;
    /** is automatically set on each row when it is inserted*/
    private Date dateCreated;
    /** is automatically set on each row when it changes*/
    private Date lastModified;
    /** value between 0.0 and 1.0....*/
    private float discountRate;
    /** can be determined with http://www.togis.com/addressGeodecoder*/
    private double invoiceAddressLongitude;
    /** can be determined with http://www.togis.com/addressGeodecoder*/
    private double invoiceAddressLatitude;
    /** PK*/
    private String customerId;
    /** FK; cf. ISO 3166*/
    private Country deliveryAddressCountry;
    /** FK; cf. ISO 3166*/
    private Country invoiceAddressCountry;
    /** FK; business customer, private, reseller etc.*/
    //private String customerTypeId;
    /** FK; business customer, private, reseller etc.*/
    private CustomerType customerType;
    /** FK; the importance of the customer; A is most, C is least important*/
    private CustomerCategory customerCategory;

    
    
    /**
     * @return the customerId
     */
    public String getCustomerId() {
        return customerId;
    }

    /**
     * @param customerId the customerId to set
     */
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getDeliveryAddressField2() {
        return deliveryAddressField2;
    }

    public void setDeliveryAddressField2(String deliveryAddressField2) {
        this.deliveryAddressField2 = deliveryAddressField2;
    }

    public String getDeliveryAddressField3() {
        return deliveryAddressField3;
    }

    public void setDeliveryAddressField3(String deliveryAddressField3) {
        this.deliveryAddressField3 = deliveryAddressField3;
    }

    public String getDeliveryAddressField1() {
        return deliveryAddressField1;
    }

    public void setDeliveryAddressField1(String deliveryAddressField1) {
        this.deliveryAddressField1 = deliveryAddressField1;
    }

    public String getDeliveryAddressStreet() {
        return deliveryAddressStreet;
    }

    public void setDeliveryAddressStreet(String deliveryAddressStreet) {
        this.deliveryAddressStreet = deliveryAddressStreet;
    }

    public String getDeliveryAddressStreetNumber() {
        return deliveryAddressStreetNumber;
    }

    public void setDeliveryAddressStreetNumber(String deliveryAddressStreetNumber) {
        this.deliveryAddressStreetNumber = deliveryAddressStreetNumber;
    }

    public String getDeliveryAddressZipCode() {
        return deliveryAddressZipCode;
    }

    public void setDeliveryAddressZipCode(String deliveryAddressZipCode) {
        this.deliveryAddressZipCode = deliveryAddressZipCode;
    }

    public String getDeliveryAddressCity() {
        return deliveryAddressCity;
    }

    public void setDeliveryAddressCity(String deliveryAddressCity) {
        this.deliveryAddressCity = deliveryAddressCity;
    }

    public double getDeliveryAddressLongitude() {
        return deliveryAddressLongitude;
    }

    public void setDeliveryAddressLongitude(double deliveryAddressLongitude) {
        this.deliveryAddressLongitude = deliveryAddressLongitude;
    }

    public double getDeliveryAddressLatitude() {
        return deliveryAddressLatitude;
    }

    public void setDeliveryAddressLatitude(double deliveryAddressLatitude) {
        this.deliveryAddressLatitude = deliveryAddressLatitude;
    }

    public String getInvoiceAddressField1() {
        return invoiceAddressField1;
    }

    public void setInvoiceAddressField1(String invoiceAddressField1) {
        this.invoiceAddressField1 = invoiceAddressField1;
    }

    public String getInvoiceAddressField2() {
        return invoiceAddressField2;
    }

    public void setInvoiceAddressField2(String invoiceAddressField2) {
        this.invoiceAddressField2 = invoiceAddressField2;
    }

    public String getInvoiceAddressField3() {
        return invoiceAddressField3;
    }

    public void setInvoiceAddressField3(String invoiceAddressField3) {
        this.invoiceAddressField3 = invoiceAddressField3;
    }

    public String getInvoiceAddressStreet() {
        return invoiceAddressStreet;
    }

    public void setInvoiceAddressStreet(String invoiceAddressStreet) {
        this.invoiceAddressStreet = invoiceAddressStreet;
    }

    public String getInvoiceAddressStreetNumber() {
        return invoiceAddressStreetNumber;
    }

    public void setInvoiceAddressStreetNumber(String invoiceAddressStreetNumber) {
        this.invoiceAddressStreetNumber = invoiceAddressStreetNumber;
    }

    public String getInvoiceAddressZipCode() {
        return invoiceAddressZipCode;
    }

    public void setInvoiceAddressZipCode(String invoiceAddressZipCode) {
        this.invoiceAddressZipCode = invoiceAddressZipCode;
    }

    public String getInvoiceAddressCity() {
        return invoiceAddressCity;
    }

    public void setInvoiceAddressCity(String invoiceAddressCity) {
        this.invoiceAddressCity = invoiceAddressCity;
    }

    public String getCommentary() {
        return commentary;
    }

    public void setCommentary(String commentary) {
        this.commentary = commentary;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastModified() {
        return lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public float getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(float discountRate) {
        this.discountRate = discountRate;
    }

    public double getInvoiceAddressLongitude() {
        return invoiceAddressLongitude;
    }

    public void setInvoiceAddressLongitude(double invoiceAddressLongitude) {
        this.invoiceAddressLongitude = invoiceAddressLongitude;
    }

    public double getInvoiceAddressLatitude() {
        return invoiceAddressLatitude;
    }

    public void setInvoiceAddressLatitude(double invoiceAddressLatitude) {
        this.invoiceAddressLatitude = invoiceAddressLatitude;
    }
    
    public Country getDeliveryAddressCountry() {
        return deliveryAddressCountry;
    }

    public void setDeliveryAddressCountry(Country deliveryAddressCountry) {
        this.deliveryAddressCountry = deliveryAddressCountry;
    }
    public Country getInvoiceAddressCountry() {
        return invoiceAddressCountry;
    }

    public void setInvoiceAddressCountry(Country invoiceAddressCountry) {
        this.invoiceAddressCountry = invoiceAddressCountry;
    }

    public CustomerType getCustomerType() {
        return customerType;
    }

    public void setCustomerType(CustomerType customerType) {
        this.customerType = customerType;
    }
    
    public CustomerCategory getCustomerCategory() {
        return customerCategory;
    }

    public void setCustomerCategory(CustomerCategory customerCategory) {
        this.customerCategory = customerCategory;
    }

}
