/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Each object of this class holds one of the possible invoice 
 * or delivery countries of customers.
 * @author Claudius Haecker
 */
public class Country implements Serializable {

    private static final long serialVersionUID = 1577944261439810380L;
    private String countryId;
    private String name;
    private String isoCode;
    private Date dateCreated;
    private Date dateLastModified;

    public Country() {
        super();
    }

    public Country(String name, String isoCode) {
        super();
        this.name = name;
        this.isoCode = isoCode;
    }

    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIsoCode() {
        if (isoCode == null) {
            isoCode = "";
        }
        return isoCode;
    }

    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    public Country(String countryId, String name, String isoCode, Date dateCreated, Date dateLastModified) {
        this.countryId = countryId;
        this.name = name;
        this.isoCode = isoCode;
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
    }

    @Override
    public boolean equals(Object obj) {
        Country o = (Country) obj;
        return this.isoCode.equals(o.getIsoCode());
    }

    @Override
    /*
     * If two objects are equal according to the equals(Object) method, then
     * calling the hashCode method on each of the two objects must produce the
     * same integer result. 
     * 
     */
    public int hashCode() {
        return this.getIsoCode().hashCode();
    }
}
