/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.domain;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import de.itemis.qimpress.showcase.order_simulator.be.dto.ProductInfo;

/**
 * Holds all information about the order item, 
 * like product, quantity and total price.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "order_item")
public class OrderItem {

    private Long id;
    
    private int quantity;
    private BigDecimal totalPrice;
    private ProductInfo product;
    // replicated ProductInfo.productCode for persisting
    private String productCode;
    
    public OrderItem() {
        super();
    }

    public OrderItem(int quantity, ProductInfo product) {
        super();
        setQuantity(quantity);
        setProduct(product);
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "order_item_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the quantity
     */
    @Column(name = "quantity")
    public int getQuantity() {
        return quantity;
    }
    
    /**
     * @param quantity the quantity to set
     */
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    /**
     * @return the totalPrice
     */
    @Column(name = "total_price")
    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    /**
     * @param totalPrice the totalPrice to set
     */
    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    /**
     * @return the product
     */
    @Transient
    public ProductInfo getProduct() {
        return product;
    }

    /**
     * @param product the product to set
     */
    public void setProduct(ProductInfo product) {
        this.product = product;
        this.productCode = (product != null) ? product.getProductCode() : null;
    }

    /**
     * @return the productCode
     */
    @Column(name = "product_code")
    public String getProductCode() {
        return productCode;
    }

    /**
     * @param productCode the productCode to set
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
    
}