/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.dao;

import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;

/**
 * Hibernate-supported implementation of the
 * {@link OrderDao} interface.
 * 
 * @author Wladimir Safonov
 *
 */
public class OrderDaoImpl extends HibernateDaoSupport implements OrderDao {

    private static final Logger LOG = Logger.getLogger(OrderDaoImpl.class);
    
    private JdbcTemplate jdbcTemplate;
    
    /**
     * @param jdbcTemplate the jdbcTemplate to set
     */
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.order_simulator.be.dao.OrderDao#save(de.itemis.qimpress.showcase.order_shipment_generator.be.domain.Order)
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED)
    public void save(Order order) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> save()");
        }

        try {
            this.getHibernateTemplate().saveOrUpdate(order);
        } catch (DataAccessException e) {
            LOG.error("Failed to save an Order", e);
            throw new DaoException(e);
        }

    }

    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED)
    public Long getNextOrderNumber() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getNextOrderNumber()");
        }
        
        Long orderNumber;
        try {
            orderNumber = (Long) jdbcTemplate.queryForObject(
                    "SELECT nextval(('public.order_number_seq'::text)::regclass)", 
                    Long.class);
        } catch (DataAccessException e) {
            LOG.error("Failed to generate new order number with sequence", e);
            throw new DaoException(e);
        }
        return orderNumber;
    }

    /* @Override */
    public List<Order> getOrdersForCustomerAndInterval(String customerNumber, Date from, Date till) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getOrdersForCustomerAndInterval()");
        }
        
        try {
            return getHibernateTemplate().find(
                    "from Order where customerNumber=? and creationDate>=? and creationDate<=?", 
                    new Object[] {customerNumber, from, till});
        } catch (DataAccessException e) {
            LOG.error("Failed to query for Orders by customerNumber and creationDate", e);
            throw new DaoException(e);
        }
    }

}
