/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.be.dao;

import java.util.Date;
import java.util.List;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.DaoException;

/**
 * DAO-operations interface for {@link Order}
 * 
 * @author Wladimir Safonov
 *
 */
public interface OrderDao {

    /**
     * Stores the given {@link Order} in the database. Instances without 
     * set {@link Order#getId() id} are inserted as new orders. 
     * The {@link Order#getId() id} of the given order object is then 
     * updated with the generated ID.
     * 
     * @param order {@link Order} to be stored in the database
     * @throws DaoException in case of a database failure
     */
    void save(Order order) throws DaoException;
    
    /**
     * Retrieves the next order number from the database sequence.
     * 
     * @return next order number
     * @throws DaoException in case of a database failure
     */
    Long getNextOrderNumber() throws DaoException;
    
    /**
     * Retrieves a list of all orders for a specific customer and time interval.
     * 
     * @param customerNumber number of the customer to find the orders for
     * @param from beginning time for the orders selection
     * @param till ending time for the orders selection
     * @return list of orders for the given customer and time interval
     * @throws DaoException in case of a database failure
     */
    List<Order> getOrdersForCustomerAndInterval(String customerNumber, Date from, Date till) throws DaoException;
}
