--
-- PostgreSQL database dump
--

-- Started on 2009-01-27 10:41:44

DROP PROCEDURAL LANGUAGE IF EXISTS plpgsql; 
CREATE PROCEDURAL LANGUAGE plpgsql;

--
-- TOC entry 1274 (class 1259 OID 248068)
-- Dependencies: 5
-- Name: customer_type_parameters; Type: TABLE; Schema: public; Owner: order_simulator_user; Tablespace: 
--

CREATE TABLE customer_type_parameters (
    customer_type_parameters_id bigint NOT NULL,
    customer_type_name character varying(255),
    max_items_per_order integer,
    min_items_per_order integer,
    max_quantity_per_item integer,
    min_quantity_per_item integer,
    global_parameters_id bigint
);


ALTER TABLE public.customer_type_parameters OWNER TO order_simulator_user;

--
-- TOC entry 1275 (class 1259 OID 248072)
-- Dependencies: 5
-- Name: global_parameters; Type: TABLE; Schema: public; Owner: order_simulator_user; Tablespace: 
--

CREATE TABLE global_parameters (
    global_parameters_id bigint NOT NULL,
    order_interval real,
    order_probability real,
    orders_batch_size integer,
    output_folder character varying(255)
);


ALTER TABLE public.global_parameters OWNER TO order_simulator_user;

--
-- TOC entry 1278 (class 1259 OID 248099)
-- Dependencies: 5
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: order_simulator_user
--

CREATE SEQUENCE hibernate_sequence
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.hibernate_sequence OWNER TO order_simulator_user;

--
-- TOC entry 1276 (class 1259 OID 248076)
-- Dependencies: 5
-- Name: order_; Type: TABLE; Schema: public; Owner: order_simulator_user; Tablespace: 
--

CREATE TABLE order_ (
    order_id bigint NOT NULL,
    customer_number character varying(255),
    creation_date timestamp without time zone,
    total_price numeric(19,2),
    additional_info1 character varying(255),
    additional_info2 character varying(255),
    additional_info3 character varying(255),
    order_number character varying(255) NOT NULL
);


ALTER TABLE public.order_ OWNER TO order_simulator_user;

--
-- TOC entry 1277 (class 1259 OID 248085)
-- Dependencies: 5
-- Name: order_item; Type: TABLE; Schema: public; Owner: order_simulator_user; Tablespace: 
--

CREATE TABLE order_item (
    order_item_id bigint NOT NULL,
    product_code character varying(255),
    quantity integer,
    total_price numeric(19,2),
    order_id bigint
);


ALTER TABLE public.order_item OWNER TO order_simulator_user;

--
-- TOC entry 1273 (class 1259 OID 247484)
-- Dependencies: 5
-- Name: order_number_seq; Type: SEQUENCE; Schema: public; Owner: order_simulator_user
--

CREATE SEQUENCE order_number_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    START WITH 16400
    CACHE 1;


ALTER TABLE public.order_number_seq OWNER TO order_simulator_user;

--
-- TOC entry 1610 (class 2606 OID 248071)
-- Dependencies: 1274 1274
-- Name: customer_type_parameters_pkey; Type: CONSTRAINT; Schema: public; Owner: order_simulator_user; Tablespace: 
--

ALTER TABLE ONLY customer_type_parameters
    ADD CONSTRAINT customer_type_parameters_pkey PRIMARY KEY (customer_type_parameters_id);


--
-- TOC entry 1612 (class 2606 OID 248075)
-- Dependencies: 1275 1275
-- Name: global_parameters_pkey; Type: CONSTRAINT; Schema: public; Owner: order_simulator_user; Tablespace: 
--

ALTER TABLE ONLY global_parameters
    ADD CONSTRAINT global_parameters_pkey PRIMARY KEY (global_parameters_id);


--
-- TOC entry 1614 (class 2606 OID 248084)
-- Dependencies: 1276 1276
-- Name: order__order_number_key; Type: CONSTRAINT; Schema: public; Owner: order_simulator_user; Tablespace: 
--

ALTER TABLE ONLY order_
    ADD CONSTRAINT order__order_number_key UNIQUE (order_number);


--
-- TOC entry 1616 (class 2606 OID 248082)
-- Dependencies: 1276 1276
-- Name: order__pkey; Type: CONSTRAINT; Schema: public; Owner: order_simulator_user; Tablespace: 
--

ALTER TABLE ONLY order_
    ADD CONSTRAINT order__pkey PRIMARY KEY (order_id);


--
-- TOC entry 1618 (class 2606 OID 248088)
-- Dependencies: 1277 1277
-- Name: order_item_pkey; Type: CONSTRAINT; Schema: public; Owner: order_simulator_user; Tablespace: 
--

ALTER TABLE ONLY order_item
    ADD CONSTRAINT order_item_pkey PRIMARY KEY (order_item_id);


--
-- TOC entry 1620 (class 2606 OID 248094)
-- Dependencies: 1277 1276 1615
-- Name: fk2d110d644df6119b; Type: FK CONSTRAINT; Schema: public; Owner: order_simulator_user
--

ALTER TABLE ONLY order_item
    ADD CONSTRAINT fk2d110d644df6119b FOREIGN KEY (order_id) REFERENCES order_(order_id);


--
-- TOC entry 1619 (class 2606 OID 248089)
-- Dependencies: 1274 1275 1611
-- Name: fke792f9ae1dfd8132; Type: FK CONSTRAINT; Schema: public; Owner: order_simulator_user
--

ALTER TABLE ONLY customer_type_parameters
    ADD CONSTRAINT fke792f9ae1dfd8132 FOREIGN KEY (global_parameters_id) REFERENCES global_parameters(global_parameters_id);


--
-- TOC entry 1625 (class 0 OID 0)
-- Dependencies: 5
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


-- Completed on 2009-01-27 10:41:44

--
-- PostgreSQL database dump complete
--

