/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.inventory_simulator.webservice;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.ws.server.endpoint.AbstractJDomPayloadEndpoint;

import de.itemis.qimpress.showcase.inventory_simulator.be.service.InventorySimulatorManager;
import de.itemis.qimpress.showcase.inventory_simulator.be.service.ServiceLocator;

/**
 * @author Wladimir Safonov
 *
 */
public class InventoryJDomEndpoint extends AbstractJDomPayloadEndpoint {

    private static final Logger LOG = Logger.getLogger(InventoryJDomEndpoint.class);
    
    private static final String CHECK_PRODUCT_AVAILABILITY_REQUEST = "CheckProductAvailabilityRequest";
    private static final String CHECK_PRODUCT_AVAILABILITY_RESPONSE = "CheckProductAvailabilityResponse";
    
    private Namespace namespace;
    private InventorySimulatorManager inventorySimulatorManager = ServiceLocator.getInstance().getInventorySimulatorManager();
    
    public InventoryJDomEndpoint() {
        super();
        namespace = Namespace.getNamespace("is", "http://www.itemis.com/inventory_simulator/schemas");
        
    }


    @Override
    protected Element invokeInternal(Element request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> invokeInternal()");
        }
        
        String rootElement = request.getName();
        if (CHECK_PRODUCT_AVAILABILITY_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " +  CHECK_PRODUCT_AVAILABILITY_REQUEST);
            }
            
            String productCode = request.getChildTextTrim("ProductCode", namespace);
            int quantity = Integer.parseInt(request.getChildTextTrim("Quantity", namespace));
            int availableQuantity = inventorySimulatorManager.checkProductAvailability(productCode, quantity);
            
            return createCheckProductAvailabilityResponse(availableQuantity);
        }
        return null;
    }

    protected Element createCheckProductAvailabilityResponse(int availaleQuantity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> createCheckProductAvailabilityResponse()");
        }
        
        Element response = new Element(CHECK_PRODUCT_AVAILABILITY_RESPONSE, namespace);
        response.addContent(new Element("AvailableQuantity", namespace).setText(Integer.toString(availaleQuantity)));
        
        return response;
    }
}
