/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.inventory_simulator.jsf.beans;

import java.io.Serializable;

import javax.naming.NamingException;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.inventory_simulator.be.domain.InventoryParameters;
import de.itemis.qimpress.showcase.inventory_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.inventory_simulator.be.service.InventorySimulatorManager;
import de.itemis.qimpress.showcase.inventory_simulator.be.service.ServiceLocator;

/**
 * The InventorySimulatorFeController class controls communication between
 * frontend and backend.
 * @author Claudius Haecker
 */
public class InventorySimulatorFeController implements Serializable {

    private static final long serialVersionUID = -6341136258825561822L;

    private static final Logger LOG = Logger.getLogger(InventorySimulatorFeController.class);

    private InventorySimulatorManager inventorySimulatorManager = ServiceLocator.getInstance()
            .getInventorySimulatorManager();

    //
    // Input from user
    //
    private float deliveryProbability;

    /**
     * constructor for the InventorySimulatorFeController.
     * The constructor instanciates the inventorySimulatorManager.
     */
    public InventorySimulatorFeController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  InventorySimulatorFeController");
        }
        if (inventorySimulatorManager == null) {
            LOG.error("inventorySimulatorManager from ServiceLocater was null");
            throw new IllegalStateException("Could not configure inventorySimulatorManager.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("inventorySimulatorManager = " + inventorySimulatorManager);
        }
    }

    /**
     * @param deliveryProbability the deliveryProbability to set
     */
    public void setDeliveryProbability(float deliveryProbability) {
        InventoryParameters inventoryParameters = new InventoryParameters();
        inventoryParameters.setProductAvailabilityProbability(deliveryProbability);
        try {
            inventorySimulatorManager.storeParameters(inventoryParameters);
        } catch (ApplicationException ae) {
            LOG.error("could not store inventoryParameters", ae);
            //TODO (MH) Read error code and trigger FE error handling 
        }
    }

    /**
     * @return the deliveryProbability
     */
    public float getDeliveryProbability() {
        try {
            return inventorySimulatorManager.loadParameters().getProductAvailabilityProbability();
        } catch (ApplicationException ae) {
            LOG.error("could not load inventoryParameters", ae);
            // TODO (MH) Read error code and trigger FE error handling 
            return Float.NaN;
        }
    }
}
