/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.inventory_simulator.tests.be.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.inventory_simulator.be.domain.InventoryParameters;
import de.itemis.qimpress.showcase.inventory_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.inventory_simulator.be.service.InventorySimulatorManager;
import de.itemis.qimpress.showcase.inventory_simulator.be.service.ServiceLocator;

/**
 * JUnit test for the the 
 * {@link de.itemis.qimpress.showcase.inventory_simulator.be.service.InventorySimulatorManager} 
 * service methods.
 * 
 * @author Wladimir Safonov
 * @author Claudius Haecker
 *
 */
public class InventorySimulatorManagerTest {

    // Logger for the InventorySimulatorManagerTest
    private static final Logger LOG = Logger.getLogger(InventorySimulatorManagerTest.class);
    
    private static InventorySimulatorManager INVENTORY_SIMULAOR_MANAGER = ServiceLocator.getInstance().getInventorySimulatorManager();
    
    @BeforeClass
    public static void initInventorySimulatorManagerTest() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initInventorySimulatorManagerTest()");
        }

        
    }
    
    @Test
    public void testLoadParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testLoadParameters()");
        }
        
        InventoryParameters parameters = null;
        try {
            parameters = INVENTORY_SIMULAOR_MANAGER.loadParameters();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to load parameters");
        }
        assertNotNull("Received null instead of parameters", parameters);
        assertEquals("ProductAvailability parameter has unexpected value", 
                0.7, parameters.getProductAvailabilityProbability(), 0.001);
    }
    
}
