/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.inventory_simulator.be.service;


import java.io.IOException;
import java.util.Properties;
import java.util.Random;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.inventory_simulator.be.domain.InventoryParameters;
import de.itemis.qimpress.showcase.inventory_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.inventory_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;

/**
 * @author Wladimir Safonov
 *
 */
public class InventorySimulatorManagerImpl implements InventorySimulatorManager {
    
    // Logger for the InventorySimulatorManagerImpl
    private static final Logger LOG = Logger.getLogger(InventorySimulatorManagerImpl.class);
    
    private static final String AVAILABILITY_PROB_KEY = "product.availability.probability";
    
    private Properties simulatorProperties;
    private Random random;
    
    public InventorySimulatorManagerImpl() throws ApplicationException {
        simulatorProperties = new Properties();
        try {
            simulatorProperties.load(this.getClass().getClassLoader().getResourceAsStream("parameters.properties"));
        } catch (IOException e) {
            LOG.error("Failed to load webservice.properties file", e);
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }    
        random = new Random();
    }

    /* @Override */
    public int checkProductAvailability(String productCode, int quantity) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> checkProductAvailability()");
        }
        
        InventoryParameters params = loadParameters();
        if (random.nextFloat() < params.getProductAvailabilityProbability()) {
            return quantity;
        }
        return 0;
    }

    /* @Override */
    public InventoryParameters loadParameters() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> loadParameters()");
        }
        
        InventoryParameters parameters = new InventoryParameters();
        float availabilityProb;
        try {
            availabilityProb = Float.parseFloat(simulatorProperties.getProperty(AVAILABILITY_PROB_KEY));
        } catch (NumberFormatException e) {
            LOG.error("ProductAvailability property value is invalid");
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        parameters.setProductAvailabilityProbability(availabilityProb);
        
        return parameters;
    }

    /* @Override */
    public void storeParameters(InventoryParameters parameters) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> storeParameters()");
        }
        
        simulatorProperties.put(AVAILABILITY_PROB_KEY, 
                Float.toString(parameters.getProductAvailabilityProbability()));
    }
    
}
