/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.inventory_simulator.be.service;

import de.itemis.qimpress.showcase.inventory_simulator.be.domain.InventoryParameters;
import de.itemis.qimpress.showcase.inventory_simulator.be.exceptions.ApplicationException;


/**
 * Service interface for the Inventory Simulator application
 * 
 * @author Wladimir Safonov
 *
 */
public interface InventorySimulatorManager {

    /**
     * Checks availability of the product with the given product code in the given quantity.
     * Returns product quantity available from the requested one.
     * 
     * @param productCode code of the product
     * @param quantity quantity to check for availability
     * @return product quantity available from the requested one
     * @throws ApplicationException in case of internal application failure
     */
    int checkProductAvailability(String productCode, int quantity) throws ApplicationException;
    
    /**
     * Loads stored parameters for the simulated inventory system.
     * 
     * @return inventory system parameters
     * @throws ApplicationException in case of internal application failure
     */
    InventoryParameters loadParameters() throws ApplicationException;
    
    /**
     * Stores given parameters for the inventory system simulation.
     * 
     * @param parameters inventory system parameters
     * @throws ApplicationException in case of internal application failure
     */
    void storeParameters(InventoryParameters parameters) throws ApplicationException;
    
}
