/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.inventory_simulator.be.domain;

/**
 * Parameters holder for the inventory system.
 * Currently contains only one parameter for the product availability.
 * 
 * @author Wladimir Safonov
 *
 */
public class InventoryParameters {

    /** probability of the product availability */
    private float productAvailabilityProbability;

    /**
     * @return the productAvailabilityProbability
     */
    public float getProductAvailabilityProbability() {
        return productAvailabilityProbability;
    }

    /**
     * @param productAvailabilityProbability the productAvailabilityProbability to set
     */
    public void setProductAvailabilityProbability(float productAvailabilityProbability) {
        this.productAvailabilityProbability = productAvailabilityProbability;
    }
}
