/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.infra;

import java.io.File;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import org.apache.activemq.broker.BrokerService;

public class EmbeddedMqBrokerServlet extends EmbeddedServlet {

	private static final String PARAM_BROKER_NAME = "brokerName";
	private static final String PARAM_BIND_ADDRESS = "bindAddress";
	private static final String DEFAULT_BROKER_NAME = "qimpress";
	private static final String DEFAULT_BIND_ADDRESS = "tcp://localhost:61616";
	/**
	 * 
	 */
	private static final long serialVersionUID = 8771858138826605867L;
	private BrokerService broker;
	
	@Override
	public void init() throws ServletException {
		File runtimeDirectory = getWorkDir();
		File jmsBroker = new File(runtimeDirectory,"jms-broker");
		if (!jmsBroker.exists()) {
			jmsBroker.mkdirs();
		}
		//String bindAddress = "tcp://localhost:61616";
		
		
		ServletConfig servletConfig = getServletConfig();
		
		String bindAddress = servletConfig.getInitParameter(PARAM_BIND_ADDRESS);
		bindAddress = bindAddress!=null ? bindAddress : DEFAULT_BIND_ADDRESS;
		
		String brokerName = servletConfig.getInitParameter(PARAM_BROKER_NAME);
		brokerName = brokerName!=null ? brokerName : DEFAULT_BROKER_NAME;

		broker = new BrokerService();
		// configure the broker
		broker.setUseJmx(false);
		broker.setBrokerName(brokerName);
		try {
			broker.addConnector(bindAddress);
			broker.setDataDirectoryFile(jmsBroker);
			broker.start();
		} catch (Exception e) {
			log("Start of Broker Service failed", e);
			throw new ServletException(e);
		}
	}
	@Override
	public void destroy() {
		if (broker!=null && broker.isStarted()) {
			try {
				broker.stop();
			} catch (Exception e) {
				log("Stop of Broker Service failed", e);
			}
		}
	}
}
