/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.demo_application.jsf.beans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.demo_app.be.dto.AttributeInfo;
import de.itemis.qimpress.showcase.demo_app.be.dto.Country;
import de.itemis.qimpress.showcase.demo_app.be.dto.CustomerCategoryDiscount;
import de.itemis.qimpress.showcase.demo_app.be.dto.CustomerType;
import de.itemis.qimpress.showcase.demo_app.be.dto.Price;
import de.itemis.qimpress.showcase.demo_app.be.dto.ProductInfo;
import de.itemis.qimpress.showcase.demo_app.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.demo_app.be.service.DemoAppManager;
import de.itemis.qimpress.showcase.demo_app.be.service.ServiceLocator;

/**
 * The DemoAppFeController class controls communication between
 * frontend and backend.
 * @author Claudius Haecker
 */
/**
 * @author Wladimir
 *
 */
/**
 * @author Wladimir
 *
 */
/**
 * @author Wladimir
 *
 */
/**
 * @author Wladimir
 *
 */
/**
 * @author Wladimir
 *
 */
/**
 * @author Wladimir
 *
 */
/**
 * @author Wladimir
 *
 */
public class DemoAppFeController {

    /**
     * 
     */
    private static final String SHOW_PARAMETERS = "SHOW_PARAMETERS";
    /**
     * 
     */
    private static final String SHOW_RESULT = "SHOW_RESULT";
    private static final Logger LOG = Logger.getLogger(DemoAppFeController.class);

    private DemoAppManager demoAppManager = ServiceLocator.getInstance().getDemoAppManager();

    //
    // Input from user
    //
    // See {@link DemoAppManager.calculateVolumePriceForCustomerCategory()}
    private String productCode;
    // ISO 3166-1-alpha-2 code
    private String countryIsoCode;
    // The date for which the Price is valid TODO, not implemented yet
    private Date date;
    // See {@link DemoAppManager.calculateVolumePriceForCustomerCategory()}
    private String categoryKey;
    // See {@link DemoAppManager.calculateVolumePriceForCustomerCategory()}
    private String typeName;
    // See {@link DemoAppManager.calculateVolumePriceForCustomerCategory()}
    private Integer quantity;

    private List<Country> allCountries;
    private boolean popupRendered;
    private AttributeInfo attribute;
    private List<AttributeInfo> attributes;
    private Price finalPrice;
    private Price listPrice;

    /**
     * constructor for the DemoAppFeController.
     * The constructor instanciates the demoAppManager.
     */
    public DemoAppFeController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  DemoAppFeController");
        }
        if (demoAppManager == null) {
            LOG.error("demoAppManager from ServiceLocater was null");
            throw new IllegalStateException("Could not configure demoAppManager.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("demoAppManager = " + demoAppManager);
        }
    }

    /**
     * returns list items for ice:selectOneMenu
     * @return a select-item list with all customer-category names
     */
    public ArrayList<SelectItem> getCustomerCategoryItems() {
    	
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> CALLED: getCustomerCategoryItems <==");
        }
        
        ArrayList<SelectItem> selectOptions = new ArrayList<SelectItem>();
        try {
            List<CustomerCategoryDiscount> discounts = demoAppManager.getAllCustomerCategoryDiscounts();
            for (CustomerCategoryDiscount discount : discounts) {
                selectOptions.add(new SelectItem(discount.getCategoryKey(), truncate(discount.getCategoryKey())));
            }
        } catch (ApplicationException ae) {
            LOG.error("!!! APPLICATION-EXCEPTION - getCustomerCategoryItems - " + "cause: " + ae.getCause(), ae);
            // TODO (MH) Read error code and trigger FE error handling 
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCustomerCategoryItems", start, stop);
        }
        
        return selectOptions;
    }

    /**
     * returns list items for ice:selectOneMenu
     * @return a select-item list with all customer-type names
     */
    public ArrayList<SelectItem> getCustomerTypeItems() {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("==> CALLED: getCustomerTypeItems <==");
        }
        ArrayList<SelectItem> selectOptions = new ArrayList<SelectItem>();
        try {
            List<CustomerType> types = demoAppManager.getCustomerTypes();
            for (CustomerType type : types) {
                selectOptions.add(new SelectItem(type.getCustomerTypeName()));
            }
        } catch (ApplicationException ae) {
            LOG.error("!!! APPLICATION-EXCEPTION - getCustomerTypeItems - " + "cause: " + ae.getCause(), ae);
            // TODO (MH) Read error code and trigger FE error handling 
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCustomerTypes", start, stop);
        }
        
        return selectOptions;
    }

    /**
     * @return the productCode
     */
    public String getProductCode() {
        return productCode;
    }

    /**
     * @param productCode the productCode to set
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    /**
     * returns list items for ice:selectOneMenu
     * @return a select-item list with all countries
     */
    public ArrayList<SelectItem> getCountryItems() {
    	
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> CALLED: getCountryItems <==");
        }
        ArrayList<SelectItem> selectOptions = new ArrayList<SelectItem>();
        try {
            if (allCountries == null) {
                allCountries = demoAppManager.getCountries();
            }
            for (Country country : allCountries) {
                selectOptions.add(new SelectItem(country.getIsoCode(), truncate(country.getName())));
            }
        } catch (ApplicationException ae) {
            LOG.error("!!! APPLICATION-EXCEPTION - getCountryItems - " + "cause: " + ae.getCause(), ae);
            // TODO (MH) Read error code and trigger FE error handling 
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCountryItems", start, stop);
        }
        
        return selectOptions;
    }

    public String getCountryName() {
		
    	long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (allCountries == null) {
            try {
                allCountries = demoAppManager.getCountries();
            } catch (ApplicationException e) {
                LOG.error("Could not find country", e);
                // TODO (MH) Read error code and trigger FE error handling 
            }
        }
        for (Country country : allCountries) {
            if (country.getIsoCode().equals(countryIsoCode)) {
                return country.getName();
            }
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCountryName", start, stop);
        }
        
        return "-";
    }

    /**
     * @return customer category key
     */
    public String getCategoryKey() {
        return categoryKey;
    }

    /**
     * @param categoryKey customer category key
     */
    public void setCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
    }

    /**
     * @return the date
     */
    public Date getDate() {
        return date;
    }

    /**
     * @param date the date to set
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * @return ISO 3166-1-alpha-2 code
     */
    public String getCountryIsoCode() {
        return countryIsoCode;
    }

    /**
     * @param countryIsoCode ISO 3166-1-alpha-2 code
     */
    public void setCountryIsoCode(String countryIsoCode) {
        this.countryIsoCode = countryIsoCode;
    }

    public String getFinalPrice() {
        if (finalPrice == null || finalPrice.getValue() == null) {
            return "-";
        } else {
            return finalPrice.getValue()
                    + (finalPrice.getCurrencySymbol() == null ? "" : " " + finalPrice.getCurrencySymbol());
        }
    }

    public String getListPrice() {
        if (listPrice == null || listPrice.getValue() == null) {
            return "-";
        } else {
            return listPrice.getValue()
                    + (listPrice.getCurrencySymbol() == null ? "" : " " + listPrice.getCurrencySymbol());
        }
    }

    public String getItemPrice() {
        if (finalPrice == null || finalPrice.getValue() == null) {
            return "-";
        } else {
            BigDecimal itemPrice = finalPrice.getValue().divide(new BigDecimal(quantity), BigDecimal.ROUND_HALF_UP);
            return itemPrice + (finalPrice.getCurrencySymbol() == null ? "" : " " + finalPrice.getCurrencySymbol());
        }
    }

    /**
     * @param typeName the typeName to set
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    /**
     * @return the typeName
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * Retrieves {@link de.itemis.qimpress.showcase.demo_app.be.dto.ProductInfo} with all
     * pertinent information describing a product with the given product code.
     * 
     * {@link de.itemis.qimpress.showcase.demo_app.be.dto.ProductInfo} for
     * @return {@link de.itemis.qimpress.showcase.demo_app.be.dto.ProductInfo} or null if not found
     */
    public ProductInfo getProductInfo() {
       
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	attributes = new ArrayList<AttributeInfo>();
        if (productCode == null || productCode.equals("")) {
            return new ProductInfo();
        }
        ProductInfo productInfo;
        try {
            productInfo = demoAppManager.getProductInfo(productCode);
            if (productInfo != null) {
                attributes = productInfo.getAttributes();
            } else {
                attributes = null;
            }
            //produced errors:
            //            if (LOG.isDebugEnabled()) {
            //                LOG.debug("1=========================");
            //                for (AttributeInfo info : attributes) {
            //                    LOG.debug(info.getAttributeDefinitionCode());
            //                }
            //                LOG.debug("2=========================");
            //            }
        } catch (ApplicationException e) {
            LOG.error("Could not get product info", e);
            // TODO (MH) Read error code and trigger FE error handling 
            productInfo = new ProductInfo();
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getProductInfo", start, stop);
        }
        
        return productInfo;
    }

    /**
     * @return the attribute to display in more detail because the user clicked it
     * 
     */
    public AttributeInfo getAttribute() {
        return attribute;
    }

    /**
     * Actionlistener if someone selects an attribute
     * @param event ignored
     */
    public void openPopup(ActionEvent event) {
        popupRendered = true;
        this.attribute = getDataForAttribute((String) FacesContext.getCurrentInstance().getExternalContext()
                .getRequestParameterMap().get("attributeDefinitionCode"));
    }

    /**
     * @return 
     * @throws ApplicationException if an error occured that cannot be resolved in the business layer
     */
    AttributeInfo getDataForAttribute(String attributeDefinitionCode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> productAttributes = " + attributeDefinitionCode);
        }
        if (attributes != null) {
            for (AttributeInfo anAttribute : attributes) {
                if (anAttribute.getAttributeDefinitionCode().equals(attributeDefinitionCode)) {
                    return anAttribute;
                }
            }
        }
        return null;
    }

    /**
     * 
     */
    public void closePopup(ActionEvent event) {
        popupRendered = false;
    }

    // ************ END GETTER / SETTER METHODS AREA **************************
    // ************************************************************************
    public String queryPrice() {
    	
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
        if (!containsNullOrEmptyString(productCode, countryIsoCode, categoryKey) && quantity != null) {
            try {
                finalPrice = demoAppManager.calculateVolumePriceForCustomerCategory(productCode, countryIsoCode,
                        quantity, categoryKey, typeName);
            } catch (ApplicationException e) {
                LOG.error("Could not calculateVolumePriceForCustomerCategory", e);
                //TODO (MH) Read error code and trigger FE error handling 
            }
        }
        if (!containsNullOrEmptyString(productCode, countryIsoCode)) {
            try {
                listPrice = demoAppManager.getProductPriceForCountry(productCode, countryIsoCode);
            } catch (ApplicationException e) {
                LOG.error("Could not calculateVolumePriceForCustomerCategory", e);
                // TODO (MH) Read error code and trigger FE error handling 
            }
        }

        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "queryPrice", start, stop);
        	Meassurements.log();
        }
        
        return SHOW_RESULT;
    }

    public String closePriceWindow() {
        return SHOW_PARAMETERS;
    }

    /**
     * truncates Strings that are longer than 15 characters
     * after 13 characters and adds three points to the String.
     * @param string the string to shorten
     * @return the shortened string
     */
    public static String truncate(String string) {
        if (string.length() > 15) {
            return string.substring(0, 13) + "...";
        } else {
            return string;
        }
    }

    /**
     * @param strings <code>String</code>-Objects to test (as comma separated list)
     * @return whether a <code>String</code>-Object is <code>null</code> or empty.
     */
    private static boolean containsNullOrEmptyString(String... strings) {
        for (String string : strings) {
            if (string == null || "".equals(string)) {
                return true;
            }
        }
        return false;
    }

    /**
     * @return the popupRendered
     */
    public boolean isPopupRendered() {
        return popupRendered;
    }

    /**
     * @return the attributes
     */
    public List<AttributeInfo> getAttributes() {
        return attributes;
    }

    /**
     * @param quantity the quantity to set
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * @return the quantity
     */
    public Integer getQuantity() {
        return quantity;
    }
}
