/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.demo_app.tests.be.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.demo_app.be.dto.Country;
import de.itemis.qimpress.showcase.demo_app.be.dto.CustomerCategoryDiscount;
import de.itemis.qimpress.showcase.demo_app.be.dto.CustomerType;
import de.itemis.qimpress.showcase.demo_app.be.dto.Price;
import de.itemis.qimpress.showcase.demo_app.be.dto.ProductInfo;
import de.itemis.qimpress.showcase.demo_app.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.demo_app.be.service.DemoAppManager;
import de.itemis.qimpress.showcase.demo_app.be.service.ServiceLocator;

/**
 * JUnit test for the the 
 * {@link de.itemis.qimpress.showcase.demo_app.be.service.DemoAppManager} 
 * service methods. As the tested methods call WebServices, it is required that
 * the corresponding WebServices are up and running before these tests get started.
 * 
 * @author Wladimir Safonov
 *
 */
public class DemoAppManagerTest {

    // Logger for the DemoAppManagerTest
    private static final Logger LOG = Logger.getLogger(DemoAppManagerTest.class);
    
    private static DemoAppManager DEMO_APP_MANAGER = ServiceLocator.getInstance().getDemoAppManager();
    
    @BeforeClass
    public static void initDemoAppManagerTest() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initDemoAppManagerTest()");
        }
        
    }
    
    @Test
    public void testGetCountries() {
        List<Country> countries = null;

        try {
            countries = DEMO_APP_MANAGER.getCountries();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getCountries()");
        }
        assertNotNull("Received null instead of countries list", countries);
        assertTrue("Received no countries", countries.size() > 0);
    }
    
    @Test
    public void testGetCustomerTypes() {
        List<CustomerType> customerTypes = null;
        
        try {
            customerTypes = DEMO_APP_MANAGER.getCustomerTypes();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getCustomerTypes()");
        }
        assertNotNull("Received null instead of customer types", customerTypes);
        assertTrue("Received no customer types", customerTypes.size() > 0);
    }
    
    @Test
    public void testGetCustomerCategoryDiscounts() {
        List<CustomerCategoryDiscount> discounts = null;
        
        try {
            discounts = DEMO_APP_MANAGER.getAllCustomerCategoryDiscounts();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getAllCustomerCategoryDiscounts()");
        }
        assertNotNull("Received null instead of CustomerCategoryDiscounts list", discounts);
        assertTrue("Received no CustomerCategoryDiscounts", discounts.size() > 0);
    }
    
    @Test
    public void testCalculateVolumePriceForCustomerCategory() {
        Price volumePrice = null;
        
        try {
            volumePrice = DEMO_APP_MANAGER.calculateVolumePriceForCustomerCategory("COAT005", "MN", 30, "B", "private");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke calculateVolumePriceForCustomerCategory()");
        }
        assertNotNull("Received null instead of Price", volumePrice);
        assertNotNull("Received empty price value", volumePrice.getValue());
        assertEquals("Received wrong price value", new BigDecimal("10340.21"), volumePrice.getValue());
    }
    
    @Test
    public void testGetProductInfo() {
        ProductInfo productInfo = null;
        
        try {
            productInfo = DEMO_APP_MANAGER.getProductInfo("SOAD005");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getProductInfo()");
        }
        assertNotNull("Received null instead of ProductInfo", productInfo);
        assertEquals("Received unexpected product name", "Adobe Photoshop Elements 7.0", productInfo.getProductName());
        assertEquals("Received unexpected product group name", "Graphic Software", productInfo.getProductGroupName());

        try {
            productInfo = DEMO_APP_MANAGER.getProductInfo("PRHP030");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getProductInfo()");
        }
        assertNotNull("Received null instead of ProductInfo", productInfo);
        assertEquals("Received unexpected product name", "HP LaserJet P1005", productInfo.getProductName());
        assertEquals("Received unexpected product group name", "Laser Mono", productInfo.getProductGroupName());
        assertNotNull("Received null instead of ProductInfo.attributes", productInfo.getAttributes());
        assertTrue("Received empty ProductInfo.attributes", productInfo.getAttributes().size() > 0);
    }
    
    @Test
    public void testGetProductPriceForCountry() {
        Price listPrice = null;
        
        try {
            listPrice = DEMO_APP_MANAGER.getProductPriceForCountry("COSE010", "BB");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getProductPriceForCountry()");
        }
        assertNotNull("Received null instead of a list price", listPrice);
        assertEquals("Received unexpected list Price", new BigDecimal("171.29"), listPrice.getValue());
        
        try {
            listPrice = DEMO_APP_MANAGER.getProductPriceForCountry("COTT005", "PM");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke getProductPriceForCountry()");
        }
        assertNotNull("Received null instead of a standard list price", listPrice);
        assertEquals("Received unexpected standard list price", new BigDecimal("18.84"), listPrice.getValue());
        
    }

}
