/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.demo_app.be.service;

import java.io.IOException;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.demo_app.be.dto.Country;
import de.itemis.qimpress.showcase.demo_app.be.dto.CustomerCategoryDiscount;
import de.itemis.qimpress.showcase.demo_app.be.dto.CustomerType;
import de.itemis.qimpress.showcase.demo_app.be.dto.Price;
import de.itemis.qimpress.showcase.demo_app.be.dto.ProductInfo;
import de.itemis.qimpress.showcase.demo_app.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.demo_app.be.exceptions.ApplicationException.ApplicationErrorCode;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetCountriesRequest;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetCountriesResponse;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetCustomerCategoryDiscountsRequest;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetCustomerCategoryDiscountsResponse;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetCustomerTypesRequest;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetCustomerTypesResponse;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetListPriceForProductRequest;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetListPriceForProductResponse;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetPriceForProductRequest;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetPriceForProductResponse;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetProductInfoRequest;
import de.itemis.qimpress.showcase.demo_app.be.messages.GetProductInfoResponse;

/**
 * @author Wladimir Safonov
 *
 */
public class DemoAppManagerImpl extends WebServiceGatewaySupport implements DemoAppManager {
    
    // Logger for the DemoAppManagerImpl
    private static final Logger LOG = Logger.getLogger(DemoAppManagerImpl.class);
    
    private Properties webServiceURIs;
    
    public DemoAppManagerImpl() throws ApplicationException {
        webServiceURIs = new Properties();
        try {
            webServiceURIs.load(this.getClass().getClassLoader().getResourceAsStream("webservice.properties"));
        } catch (IOException e) {
            LOG.error("Failed to load webservice.properties file", e);
            throw new ApplicationException(ApplicationErrorCode.TE);
        }
    }

    /* @Override */
    public List<CustomerCategoryDiscount> getAllCustomerCategoryDiscounts() throws ApplicationException {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("getAllCustomerCategoryDiscounts()");
        }

        // create request element & invoke web service
        GetCustomerCategoryDiscountsRequest request = new GetCustomerCategoryDiscountsRequest();
        GetCustomerCategoryDiscountsResponse response =
            (GetCustomerCategoryDiscountsResponse) getWebServiceTemplate().marshalSendAndReceive(
                    webServiceURIs.getProperty("pricing.ws.uri"), request);
        
        List<CustomerCategoryDiscount> list = response.getCustomerCategoryDiscounts();
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getAllCustomerCategoryDiscounts", start, stop);
        }
        
        return list;
    }

    /* @Override */
    public List<Country> getCountries() throws ApplicationException {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("getCountries()");
        }
        
        // create request element & invoke web service
        GetCountriesRequest request = new GetCountriesRequest();
        GetCountriesResponse response = 
            (GetCountriesResponse) getWebServiceTemplate().marshalSendAndReceive(
                    webServiceURIs.getProperty("crm.ws.uri"), request);
        
        List<Country> list = response.getCountries();
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCountries", start, stop);
        }
        
        return list;
    }
    
    /* @Override */
    public List<CustomerType> getCustomerTypes() throws ApplicationException {
       
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("getCustomerTypes()");
        }
        
        // create request element & invoke web service
        GetCustomerTypesRequest request = new GetCustomerTypesRequest();
        GetCustomerTypesResponse response = 
            (GetCustomerTypesResponse) getWebServiceTemplate().marshalSendAndReceive(
                webServiceURIs.getProperty("crm.ws.uri"), request);
        
        List<CustomerType> list = response.getCustomerTypes();
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCustomerTypes", start, stop);
        }
        
        return list;
    }

    /* @Override */
    public Price calculateVolumePriceForCustomerCategory(String productCode, String countryCode, int amount,
            String customerCategoryKey, String customerType) throws ApplicationException {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
		if (LOG.isDebugEnabled()) {
            LOG.debug("calculateVolumePriceForCustomerCategory()");
        }
        
        // create request element 
        GetPriceForProductRequest request = new GetPriceForProductRequest();
        request.setProductCode(productCode);
        request.setCountryIsoCode(countryCode);
        request.setProductAmount(amount);
        request.setCustomerCategory(customerCategoryKey);
        request.setCustomerType(customerType);

        // invoke web service
        GetPriceForProductResponse response = 
            (GetPriceForProductResponse) getWebServiceTemplate().marshalSendAndReceive(
                    webServiceURIs.getProperty("pricing.ws.uri"), request);
        
        Price price = response.getProductPrice();
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "calculateVolumePriceForCustomerCategory", start, stop);
        }
        
        return price;
    }

    /* @Override */
    public ProductInfo getProductInfo(String productCode) throws ApplicationException {
       
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("getProductInfo()");
        }
        
        // create request element
        GetProductInfoRequest request = new GetProductInfoRequest();
        request.setProductCode(productCode);
        
        // invoke web service
        GetProductInfoResponse response = 
            (GetProductInfoResponse) getWebServiceTemplate().marshalSendAndReceive(
                    webServiceURIs.getProperty("pdm.ws.uri"), request);
        
        ProductInfo productInfo = response.getProductInfo();
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getProductInfo", start, stop);
        }
        
        return productInfo;
    }

    /* @Override */
    public Price getProductPriceForCountry(String productCode, String countryCode) throws ApplicationException {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
        
        // create request element
        GetListPriceForProductRequest request = new GetListPriceForProductRequest();
        request.setProductCode(productCode);
        request.setCountryIsoCode(countryCode);
        
        // invoke web service
        GetListPriceForProductResponse response = (GetListPriceForProductResponse) getWebServiceTemplate()
                .marshalSendAndReceive(webServiceURIs.getProperty("pricing.ws.uri"), request);

        Price price = response.getProductPrice();
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getProductPriceForCountry", start, stop);
        }
        
        return price; 
    }
    
}
