/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.jsf.beans;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import javax.faces.context.FacesContext;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * test class for CrmSimulatorFeController
 * @author Claudius Haecker
* @author Oli
*/
public class CrmSimulatorFeControllerTest {
    private static final Logger LOG = Logger.getLogger(CrmSimulatorFeControllerTest.class);
    private static CrmSimulatorFeController crmController;
    private static CustomerFilter filter;
    private static GmapBean gmapBean;

    /**
     * Asserts that an object is null or it toString-method returns "".
     * If it isn't an {@link AssertionError} is
     * thrown.
     * 
     * @param o
     *            Object to check or <code>null</code>
     */
    public static void assertNullOrEmpty(Object o) {
        assertTrue(o == null || "".equals(o.toString()));
    }

    /**
     * tests the constructor CrmSimulatorFeController
     */
    @BeforeClass
    public static void setUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  setUp");
        }
        crmController = new CrmSimulatorFeController();
        filter = crmController.getCustomerFilter();
        gmapBean = new GmapBean();
        gmapBean.setCrmController(crmController);
    }

    /**
     * tests filterCustomers
     */
    @Test
    public void testFilterCustomers() {
        assertEquals("SHOW_QIMPRESS_FILTER", crmController.filterCustomers());
        crmController.setCustomerFilterCategoryString("test");
        assertEquals("test", filter.getCategory().getCustomerCategoryKey());
    }

    /**
     * tests resetCustomerFilter
     */
    @Test
    public void testResetCustomerFilter() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  testResetCustomerFilter");
        }
        filter.getCategory().setCustomerCategoryId("cid");
        filter.getCategory().setCustomerCategoryKey("ckey");
        filter.getCategory().setCustomerCategoryName("cname");
        filter.getCustomerType().setCustomerTypeId("tid");
        filter.getCustomerType().setCustomerTypeKey("tkey");
        filter.getCustomerType().setCustomerTypeName("tname");
        filter.getInvoiceCountry().setCountryId("icrid");
        filter.getInvoiceCountry().setIsoCode("icrisoCode");
        filter.getInvoiceCountry().setName("icrname");
        filter.getDeliveryCountry().setCountryId("dcrid");
        filter.getDeliveryCountry().setIsoCode("dcrisoCode");
        filter.getDeliveryCountry().setName("dcrname");
        filter.setCustomerNamePattern("customerNamePattern");
        filter.setCustomerNumberPattern("customerNumberPattern");

        crmController.resetCustomerFilter();

        assertNullOrEmpty(filter.getCategory().getCustomerCategoryId());
        // self test
        assertNullOrEmpty(null);
        assertNullOrEmpty("");

        assertNullOrEmpty(filter.getCategory().getCustomerCategoryId());
        assertNullOrEmpty(filter.getCategory().getCustomerCategoryKey());
        assertNullOrEmpty(filter.getCategory().getCustomerCategoryName());
        assertNullOrEmpty(filter.getCustomerType().getCustomerTypeId());
        assertNullOrEmpty(filter.getCustomerType().getCustomerTypeKey());
        assertNullOrEmpty(filter.getCustomerType().getCustomerTypeName());
        assertNullOrEmpty(filter.getInvoiceCountry().getCountryId());
        assertNullOrEmpty(filter.getInvoiceCountry().getIsoCode());
        assertNullOrEmpty(filter.getInvoiceCountry().getName());
        assertNullOrEmpty(filter.getDeliveryCountry().getCountryId());
        assertNullOrEmpty(filter.getDeliveryCountry().getIsoCode());
        assertNullOrEmpty(filter.getDeliveryCountry().getName());
        assertNullOrEmpty(filter.getCustomerNamePattern());
        assertNullOrEmpty(filter.getCustomerNumberPattern());
    }

    @Test
    public void testShowMethods() {
        assertEquals("SHOW_WELCOME", crmController.showWelcome());
        assertEquals("SHOW_QIMPRESS", crmController.showQimpress());
        assertEquals("SHOW_QIMPRESS_FILTER", crmController.showQimpress(true));
        assertEquals("SHOW_QIMPRESS", crmController.showQimpress(false));
    }

    @Test
    public void testTruncate() {
        String input[] = { "qwe", "qarwdsag", "dasgklhadsfalksdrj", "12345678901234", "1234567890123", "123456789012",
                "12345678901" };
        String expected[] = { "qwe", "qarwdsag", "dasgklhads...", "1234567890...", "1234567890...", "123456789012",
                "12345678901" };
        for (int i = 0; i < input.length; i++) {
            assertEquals(expected[i], CrmSimulatorFeController.truncate(input[i]));
        }

    }

    @Test
    public void testGetCustomerTypeItems() {
        // all types + the empty type
        assertEquals(3+1, crmController.getCustomerTypeItems().size());
        
    }

    @Test
    public void testGetCustomerCategoryItems() {
        assertEquals(3+1, crmController.getCustomerCategoryItems().size());
    }

    @Test
    public void testGetCountryItems() {
        assertEquals(245+1, crmController.getCountryItems().size());
    }
    
    
    @Test
    public void testSetDetailCustomerByRequestParameterID() {
        FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().put("detailCustomerID", "2");
        crmController.setDetailCustomerByRequestParameterID();
        assertEquals("Dr. Ing. h.c. F. Porsche AG", crmController.getDetailCustomer().getName());
    }
}
