/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.webservice;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import org.junit.Test;

import static org.junit.Assert.*;


/**
 * Tests the CrmJDomEndpoint class.
 */
public class CrmJDomEndpointTest {


    private static final Logger LOG = Logger.getLogger(CrmJDomEndpointTest.class);


    /**
     * Tests the request and response for the service method getCountries.
     */
    @Test
    public void testGetCountriesRequestAndResponse() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - testGetCountriesRequestAndResponse");
        }
        // GetCoutriesRequest element (no parameters, no child elements)
        Element rootRequestElement = new Element(CrmJDomEndpoint.GET_COUNTRIES_REQUEST);
        // => creates: <GetCountriesRequest />

        CrmJDomEndpoint crmJDomEndpoint = new CrmJDomEndpoint();

        try {
            Element responseElement = crmJDomEndpoint.invokeInternal(rootRequestElement);
            assertNotNull(responseElement);
            assertEquals(CrmJDomEndpoint.GET_COUNTRIES_RESPONSE, responseElement.getName());
            List<Element> responseElementsList = responseElement.getContent();

            if (LOG.isDebugEnabled()) {
                LOG.debug("responseElementsList-size = " +responseElementsList.size());
            }
            // there must be 245 county elements in the response
            assertEquals(245, responseElementsList.size());

            // TODO test namespace, prefix and uri

            // generate xml test output file:
            generateTestXMLOutput(responseElement, "testCountriesResponse.xml");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }



    /**
     * Tests the request and response
     * for the service method getCustomerTypes.
     */
    @Test
    public void testGetCustomerTypesRequestAndResponse() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - testGetCustomerTypesRequestAndResponse");
        }
        // GetCustomerTypesRequest element (no parameters)
        Element typesRequest = new Element(
                CrmJDomEndpoint.GET_CUSTOMERTYPES_REQUEST);

        CrmJDomEndpoint crmJDomEndpoint = new CrmJDomEndpoint();
        try {
            Element typesResponse = crmJDomEndpoint.invokeInternal(typesRequest);
            assertNotNull(typesResponse);
            List < Element > responseTypesElementList =
                    typesResponse.getContent();

            if (LOG.isDebugEnabled()) {
                LOG.debug("responseTypesElementList-size = " +responseTypesElementList.size());
            }
            // there must be 3 type elements in the response
            assertEquals(3, responseTypesElementList.size());

            // TODO test namespace, prefix and uri, test the 3 elements?

            // generate xml test output file:
            generateTestXMLOutput(typesResponse, "testTypesResponse.xml");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }



    /**
     * Tests the request and response
     * for the service method getCustomerCategories.
     */
    @Test
    public void testGetCustomerCategoriesRequestAndResponse() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - testGetCustomerCategoriesRequestAndResponse");
        }
        // GetCustomerCategoriesRequest element (no parameter)
        Element categoriesRequest = new Element(
                CrmJDomEndpoint.GET_CUSTOMERCATEGORIES_REQUEST);

        CrmJDomEndpoint crmJDomEndpoint = new CrmJDomEndpoint();

        try {
            Element categoriesResponse =
                    crmJDomEndpoint.invokeInternal(categoriesRequest);
            assertNotNull(categoriesResponse);
            List < Element > responseCategoriesElementList =
                    categoriesResponse.getContent();

            if (LOG.isDebugEnabled()) {
                LOG.debug("responseCategoriesElementList-size = " +responseCategoriesElementList.size());
            }
            // there must be 3 category elements in the response
            assertEquals(3, responseCategoriesElementList.size());
            
            // TODO test namespace, prefix and uri, test the 3 elements?

         // generate xml test output file:
            generateTestXMLOutput(categoriesResponse, "testCategoriesResponse.xml");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }



    @Test
    public void testQueryCustomersRequestAndResponse() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - testQueryCustomersRequestAndResponse");
        }
        // QueryCustomerRequest element with parameter customerFilter
        Element queryRequest = createQueryCustomerRequestElement();

        // create test xml output file for request
        generateTestXMLOutput(queryRequest, "testQueryCustomersRequest.xml");

        CrmJDomEndpoint crmJDomEndpoint = new CrmJDomEndpoint();

        try {
            Element queryCustomerResponse = crmJDomEndpoint.invokeInternal(queryRequest);
            /* for the following CustomerFilter settings : 
             * String customerNamePattern:              (empty)
             * String customerNumberPattern:            "009"
             * CustomerCategory category - categoryKey: "B"
             * CustomerType customerType - typeName:    "reseller"
             * Country deliveryCountry - name:          "GERMANTY"
             * Country invoiceCountry:                  (empty)
             * => we expect a customer list with only one element:
             * customer: "EvoBus GmbH"
             * */
            assertNotNull(queryCustomerResponse);
            /*List < Element > responseTypesElementList =
                    typesResponse.getContent();*/
            List < Element > responseCustomersElementList =
                    queryCustomerResponse.getContent();
            assertEquals(1, responseCustomersElementList.size());
            // TODO: get customer from the list and test the customer-attributes
            // generate xml test output file for response:
            generateTestXMLOutput(queryCustomerResponse, "testQueryCustomersResponse.xml");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }



    /**
     * creates a test request element for queryCustomer.
     * @return
     */
    private Element createQueryCustomerRequestElement() {
        Element queryRequest = new Element(
                CrmJDomEndpoint.GET_QUERYCUSTOMER_REQUEST);
        Namespace namespace = Namespace.getNamespace("crm", "http://www.itemis.com/crm/schemas");
        // set the CustomerFilter parameter for request
        //Element nextElement = new Element("Country", namespace);
        //nextElement.addContent(new Element("countryName", namespace).addContent(country.getName()));
        // create customer-filter-element and add filter details:
        Element customerFilterEl = new Element("customerFilter", namespace);
        customerFilterEl.addContent(
                new Element("customerNamePattern", namespace));
        customerFilterEl.addContent(new Element(
                "customerNumberPattern", namespace).addContent("009"));
        // create Element categoryFilter (only customerCategoryKey is set):
        Element categoryFilterEl = new Element("categoryFilter", namespace);
        categoryFilterEl.addContent(new Element("customerCategoryId", namespace));
        categoryFilterEl.addContent(new Element("customerCategoryKey", namespace)
                .addContent("B"));
        categoryFilterEl.addContent(
                new Element("customerCategoryName", namespace));
        categoryFilterEl.addContent(
                new Element("customerCategoryDateCreated", namespace));
        categoryFilterEl.addContent(
                new Element("customerCategoryDateModified", namespace));
        // add element categoryFilter to customerFilterElement:
        customerFilterEl.addContent(categoryFilterEl);
        // create customerFilterEl element (only customerTypeName is set):
        Element customerTypeEl = new Element("typeFilter", namespace);
        customerTypeEl.addContent(new Element("customerTypeId", namespace));
        customerTypeEl.addContent(new Element("customerTypeKey", namespace));
        customerTypeEl.addContent(new Element("customerTypeName", namespace)
                .addContent("reseller"));
        customerTypeEl.addContent(new Element(
                "customerTypeDateCreated", namespace));
        customerTypeEl.addContent(new Element(
                "customerTypeDateModified", namespace));
        // add element customerType to customerFilterElement:
        customerFilterEl.addContent(customerTypeEl);
        // create element deliveryCountryEl (only countyName is set)
        Element deliveryCountryEl = new Element("deliveryCountry", namespace);
        deliveryCountryEl.addContent(new Element("countryId", namespace));
        deliveryCountryEl.addContent(new Element("countryIsoCode", namespace));
        deliveryCountryEl.addContent(new Element("countryName", namespace).addContent("GERMANY"));
        deliveryCountryEl.addContent(new Element("countryDateCreated", namespace));
        deliveryCountryEl.addContent(new Element("countryDateModified", namespace));
        // add element deliveryCountryEl to customerFilterElement
        customerFilterEl.addContent(deliveryCountryEl);
        // create (empty) element invoiceCountry
        Element invoiceCountryEl = new Element("invoiceCountry", namespace);
        invoiceCountryEl.addContent(new Element("countryId", namespace));
        invoiceCountryEl.addContent(new Element("countryIsoCode", namespace));
        invoiceCountryEl.addContent(new Element("countryName", namespace));
        invoiceCountryEl.addContent(new Element("countryDateCreated", namespace));
        invoiceCountryEl.addContent(new Element("countryDateModified", namespace));
        // add element deliveryCountryEl to customerFilterElement
        customerFilterEl.addContent(invoiceCountryEl);

        // add element customerFilterEl to request
        queryRequest.addContent(customerFilterEl);
        return queryRequest;
    }





    /**
     * method to generate xml test-output.
     * */
    private void generateTestXMLOutput(Element responseElement, String filename) {
        Document doc = new Document(responseElement);
        XMLOutputter serializer = new XMLOutputter();
        FileOutputStream fos = null;
        try {
            //serializer.output(doc, System.out);
            fos = new FileOutputStream(new File(filename));
            serializer.output(doc, fos);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        try {
            fos.close();
        } catch (IOException e) {
            fail("Error closing Stream");
            e.printStackTrace();
        }
        
    }



}
