/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.webservice;

import java.util.List;
import java.util.Random;

import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.ws.server.endpoint.AbstractJDomPayloadEndpoint;

import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;

/**
 * CRM Webservice Endpoint for service methods designated for 
 * Order Shipment Generator
 * 
 * @author Wladimir Safonov
 *
 */
public class Crm4OsgJDomEndpoint extends AbstractJDomPayloadEndpoint {

    // Logger for Crm4OsgJDomEndpoint
    private static final Logger LOG = Logger.getLogger(Crm4OsgJDomEndpoint.class);
    
    // Payload root elements names
    public static final String GET_RANDOM_CUSTOMER_NUMBER_REQUEST = "GetRandomCustomerNumberRequest";
    public static final String GET_RANDOM_CUSTOMER_NUMBER_RESPONSE = "GetRandomCustomerNumberResponse";
    
    private static final Namespace CRM_NAMESPACE = Namespace.getNamespace("crm", "http://www.itemis.com/crm/schemas");
    
    private JdbcTemplate jdbcTemplate;
    private Random random = new Random();
    
    /**
     * @param jdbcTemplate the jdbcTemplate to set
     */
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    protected Element invokeInternal(Element request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called invokeInternal()"); 
        }
        
        String rootElementName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("detected request root element: " + rootElementName); 
        }
        if (GET_RANDOM_CUSTOMER_NUMBER_REQUEST.equals(rootElementName)) {
            
            // load the list of customer numbers
            List<String> customerNumbers = null;
            try {
                customerNumbers = jdbcTemplate.queryForList("SELECT customer_number FROM customer", String.class);
            } catch (DataAccessException e) {
                LOG.error("Failed to load the list of stored customer numbers", e);
                throw new ApplicationException(ApplicationErrorCode.TE, e);
            }
            
            // pick up a random customer number
            String randomCustomerNumber = customerNumbers.get(random.nextInt(customerNumbers.size()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Picked up random customer number: " + randomCustomerNumber);
            }
            
            // create a response element
            return createGetRandomCustomerNumberResponse(randomCustomerNumber);
        }
        
        return null;
    }

    private Element createGetRandomCustomerNumberResponse(String customerNumber) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called createGetRandomCustomerNumberResponse()");
        }
        
        // create response element
        Element responseRoot = new Element(GET_RANDOM_CUSTOMER_NUMBER_RESPONSE, CRM_NAMESPACE);
        responseRoot.addContent(new Element("CustomerNumber", CRM_NAMESPACE).setText(customerNumber));
        
        return responseRoot;
    }
}
