/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.jsf.beans;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.icesoft.faces.component.gmap.GMapLatLng;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;

/**
 * <p>
 * The GmapBean is responsible for setting up default map markers, as well as
 * the selecting of cities, searching for addresses, and toggling the visibility
 * of the map ui controls.
 * </p>
 * 
 * @since 1.7
 * @author Oliver Bräuninger
 * @author Claudius Haecker
 */
public class GmapBean {

    private CrmSimulatorFeController crmController;

    private static final Logger LOG = Logger.getLogger(CrmSimulatorFeController.class);

    // city location selected from a preset list
    // private String standardAddress = "";
    // whether we should search for an address or not
    private boolean locateAddress = false;
    private List<GMapLatLng> mapPoints = new ArrayList<GMapLatLng>();
    private boolean showControls = true;
    private boolean showMarkers = true;
    // value bound to the gmap component
    // private String address = "";

    public static final String DEFAULT_LATITUDE = "48.898544";
    public static final String DEFAULT_LONGITUDE = "8.717322";
    public static final String DEFAULT_ZOOMLEVEL = "3";

    // attributes for gmap
    //    private String zoomLevel = DEFAULT_ZOOMLEVEL;
    //    private String centerLatitude = DEFAULT_LATITUDE;
    //    private String centerLongitude = DEFAULT_LONGITUDE;

    private String customerDeliveryAdress = "";

    public GmapBean() {
        // Generate a set of default map marker locations
        // points.add(new GMapLatLng("37.379434", "-121.92293"));
        // points.add(new GMapLatLng("33.845449", "-84.368682"));
        // points.add(new GMapLatLng("34.05333", "-118.24499"));
        // points.add(new GMapLatLng("33.072694", "-97.06234"));
        // points.add(new GMapLatLng("37.391278", "-121.952451"));

    }

    /**
     * get a list of points 
     * @return a list of Points on the earth surface
     */
    public List<GMapLatLng> getPoints() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\t=> getPoints");
        }
        List<GMapLatLng> points = new ArrayList<GMapLatLng>();
        List<Customer> customers = crmController.getCustomers();
        for (Customer customer : customers) {
            points.add(new GMapLatLng(String.valueOf(customer.getDeliveryAddressLatitude()), String.valueOf(customer
                    .getDeliveryAddressLongitude())));
            if (LOG.isDebugEnabled()) {
                LOG.debug("\t=>LATITUDE = " + String.valueOf(customer.getDeliveryAddressLatitude())
                        + "\t=>LONGITUDE = " + String.valueOf(customer.getDeliveryAddressLongitude()));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\t***** => points-size = " + points.size());
        }
        return points;
    }

    public boolean isShowControls() {
        return showControls;
    }

    public void setShowControls(boolean showControls) {
        this.showControls = showControls;
    }

    public boolean isShowMarkers() {
        return showMarkers;
    }

    public void setShowMarkers(boolean showMarkers) {
        this.showMarkers = showMarkers;
    }

    /**
     * Method to determine if we should use a preset address or search for an
     * address.
     * @return true to locate an address, false otherwise
     */
    public boolean isLocateAddress() {
        // locateAddress = crmController.isLocateAddress();
        if (locateAddress) {
            locateAddress = false;
            return true;
        }
        // return false
        return crmController.isLocateAddress();
    }

    /**
     * getter for crmController.
     * @return the crmController that controls most parts of the crm view 
     */
    public CrmSimulatorFeController getCrmController() {
        return crmController;
    }

    public void setCrmController(CrmSimulatorFeController crmController) {
        this.crmController = crmController;
    }

    public String getCustomerDeliveryAdress() {
        return customerDeliveryAdress;
    }

    public void setCustomerDeliveryAdress(String customerDeliveryAdress) {
        this.customerDeliveryAdress = customerDeliveryAdress;
    }

    public String getZoomLevel() {
        // zoomLevel = crmController.getZoomLevel();
        return crmController.getZoomLevel();
    }

    public void setZoomLevel(String theZoomLevel) {
        crmController.setZoomLevel(theZoomLevel);
    }

    public String getCenterLatitude() {
        // centerLatitude = crmController.getCenterLatitude();
        return crmController.getCenterLatitude();
    }

    public void setCenterLatitude(String centerLatitude) {
        crmController.setCenterLatitude(centerLatitude);
    }

    public String getCenterLongitude() {
        // centerLongitude = crmController.getCenterLongitude();
        return crmController.getCenterLongitude();
    }

    public void setCenterLongitude(String centerLongitude) {
        crmController.setCenterLongitude(centerLongitude);
    }

    public String getAddress() {
        return crmController.getAddress();
    }

    public void setAddress(String address) {
        crmController.setAddress(address);
    }

    public List<GMapLatLng> getMapPoints() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\t********** getMapPoints **********");
        }
        mapPoints = crmController.getMapPoints();
        if (LOG.isDebugEnabled()) {
            LOG.debug("\t********** mapPoints.size() = " + mapPoints.size());
        }
        return crmController.getMapPoints();
    }

    public void setMapPoints(List<GMapLatLng> mapPoints) {
        crmController.setMapPoints(mapPoints);
    }

}
