/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Date;
import java.util.List;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Country;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerCategory;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;

/**
 * This JUnit test class tests the ServiceLocator and the basic services, namely
 * crm.getCountries(), crm.getCustomerCategories() and crm.getCustomerTypes().
 * @author Claudius Haecker
 *
 */
public class CRMManagerTest {

    private static final Logger LOG = Logger.getLogger(CRMManagerTest.class);
    private static final CRMManager CRM_MANAGER = ServiceLocator.getInstance().getCRMManager();

    /**
     * The setUp method is called once before running the test.
     * It gets an CRMManager instance (crm) that is used in the
     * different test methods.
     */
    @BeforeClass
    public static void setUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: setUp");
        }
    }

    /**
     * Tests that the CRMManager crm instanciated in the setUp method
     * is not null.
     */
    @Test
    public void testGetCRM() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testGetCRM");
        }
        assertNotNull(CRM_MANAGER);
    }

    @Test
    public void testGetCountries() {
        List<Country> countryList = null;
        try {
            countryList = CRM_MANAGER.getCountries();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
        assertNotNull(countryList);
        String countryId = null;
        String name = null;
        String isoCode = "DE";
        Date dateCreated = new Date();
        Date lastModified = new Date();
        Country germany = new Country(countryId, name, isoCode, dateCreated, lastModified);
        assertTrue(countryList.contains(germany));
        assertTrue(countryList.size() == 245);
        assertEquals(countryList.size(), 245);
        for (Country country : countryList) {
            if ("-132".equals(country.getCountryId())) {
                assertEquals("PANAMA", country.getName());
                assertEquals("PA", country.getIsoCode());
                return;
            }
        }
        // test fails if country -132 does not exist
        fail();
    }

    @Test
    public void testGetCustomerTypes() {
        List<CustomerType> customerTypesList = null;
        try {
            customerTypesList = CRM_MANAGER.getCustomerTypes();
        } catch (ApplicationException e) {
            fail();
            e.printStackTrace();
        }
        assertNotNull(customerTypesList);
        assertTrue(customerTypesList.size() > 0);
        CustomerType businessType = null;
        CustomerType privateType = null;
        CustomerType resellerType = null;
        for (CustomerType customerType : customerTypesList) {
            if ("-5".equals(customerType.getCustomerTypeId())) {
                businessType = customerType;
            }
            if ("-6".equals(customerType.getCustomerTypeId())) {
                privateType = customerType;
            }
            if ("-7".equals(customerType.getCustomerTypeId())) {
                resellerType = customerType;
            }
        }
        assertNotNull(businessType);
        assertEquals("business", businessType.getCustomerTypeName());
        assertEquals("b", businessType.getCustomerTypeKey());
        assertNotNull(privateType);
        assertEquals("private", privateType.getCustomerTypeName());
        assertEquals("p", privateType.getCustomerTypeKey());
        assertNotNull(resellerType);
        assertEquals("reseller", resellerType.getCustomerTypeName());
        assertEquals("r", resellerType.getCustomerTypeKey());
    }

    @Test
    public void testGetCustomerCategories() {
        List<CustomerCategory> customerCategoriesList = null;
        try {
            customerCategoriesList = CRM_MANAGER.getCustomerCategories();
        } catch (ApplicationException e) {
            fail();
            e.printStackTrace();
        }
        assertNotNull(customerCategoriesList);
        assertTrue(customerCategoriesList.size() > 0);
        CustomerCategory criticalCategory = null;
        CustomerCategory importantCategory = null;
        CustomerCategory unimportantCategory = null;
        for (CustomerCategory customerCategory : customerCategoriesList) {
            if ("-1".equals(customerCategory.getCustomerCategoryId())) {
                criticalCategory = customerCategory;
            }
            if ("-2".equals(customerCategory.getCustomerCategoryId())) {
                importantCategory = customerCategory;
            }
            if ("-3".equals(customerCategory.getCustomerCategoryId())) {
                unimportantCategory = customerCategory;
            }
        }
        assertNotNull(criticalCategory);
        assertEquals("business critical customer", criticalCategory.getCustomerCategoryName());
        assertEquals("A", criticalCategory.getCustomerCategoryKey());
        assertNotNull(importantCategory);
        assertEquals("important customer", importantCategory.getCustomerCategoryName());
        assertEquals("B", importantCategory.getCustomerCategoryKey());
        assertNotNull(unimportantCategory);
        assertEquals("unimportant customer", unimportantCategory.getCustomerCategoryName());
        assertEquals("C", unimportantCategory.getCustomerCategoryKey());
    }
}
