/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.service;

import static org.junit.Assert.*;

import java.util.List;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * tests 3 ways to set the category filter,
 * success is verified by checking the list returned from the database.
 * @author Claudius Haecker
 */
public class CRMManagerFilterTypeTest {

    private static final Logger LOG = Logger
            .getLogger(CRMManagerFilterTypeTest.class);
    private static CRMManager crm = ServiceLocator.getInstance().getCRMManager();

    /**
     * The setUp method is called once before running the test.
     * It gets an CRMManager instance (crm) that is used in the
     * different test methods.
     */
    @BeforeClass
    public static void setUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: setUp");
        }
        
    }

    /**
     * Tests that the CRMManager crm instanciated in the setUp method
     * is not null.
     */
    @Test
    public void testGetCRM() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testGetCRM");
        }
        assertNotNull(crm);
    }


    @Test
    public void testType() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testType");
        }
        CustomerFilter filter = new CustomerFilter();
        List<Customer> customerList = null;
        try {
            //public CustomerType(String customerTypeId, String customerTypeName,
            //        String customerTypeKey, Date dateCreated,
            //        Date lastModified) {
            filter.setCustomerType(new CustomerType("-7", "reseller", "r", null, null));
            customerList = crm.queryCustomers(filter);
            assertEquals(7, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * tests filter attribute customerType, especially the customerType
     * attribute customerTypeName with method setCustomerTypeByName()
     */
    @Test
    public void testCustomerTypeByName(){
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testCustomerTypeByName");
        }
        CustomerFilter filter = new CustomerFilter();
        filter.setCustomerTypeByName("business");
        List<Customer> customerList = null;
        try {
            customerList = crm.queryCustomers(filter);
            assertEquals(3, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }        
    }
    
    /**
     * tests filter attribute customerType, especially the customerType
     * attribute customerTypeKey with method setCustomerTypeByKey()
     */
    @Test
    public void testCustomerTypeByKey(){
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testCustomerTypeByKey");
        }
        CustomerFilter filter = new CustomerFilter();
        filter.setCustomerTypeByKey("p");
        List<Customer> customerList = null;
        try {
            customerList = crm.queryCustomers(filter);
            assertEquals(9, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }        
    }

}
