/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.service;

import static org.junit.Assert.*;

import java.util.List;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Country;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * tests 3 ways to set the country filter,
 * success is verified by checking the list returned from the database 
 * @author Claudius Haecker
 */
public class CRMManagerFilterCountryTest {
    //TestF�lle:
//    //    INSERT INTO country (date_created, last_modified, name, iso_code, country_id) 
//    VALUES ('2008-09-01 16:03:39.203', '2008-09-01 16:03:39.203', 'UNITED KINGDOM', 'GB', '-70'); (4 Kunden)
//    //    INSERT INTO country (date_created, last_modified, name, iso_code, country_id)
//    VALUES ('2008-09-01 16:03:39.203', '2008-09-01 16:03:39.203', 'GERMANY', 'DE', '-221'); (11 Kunden)
//    //    INSERT INTO country (date_created, last_modified, name, iso_code, country_id)
//    VALUES ('2008-09-01 16:03:39.203', '2008-09-01 16:03:39.203', 'FRANCE', 'FR', '-228'); (4 Kunden)

    private static final Logger LOG = Logger
            .getLogger(CRMManagerFilterCountryTest.class);
    private static CRMManager crm = ServiceLocator.getInstance().getCRMManager();

    /**
     * The setUp method is called once before running the test.
     * It gets an CRMManager instance (crm) that is used in the
     * different test methods.
     */
    @BeforeClass
    public static void setUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: setUp");
        }
        
    }

    /**
     * Tests that the CRMManager crm instanciated in the setUp method
     * is not null.
     */
    @Test
    public void testGetCRM() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testGetCRM");
        }
        assertNotNull(crm);
    }

    @Test
    public void testCountry() {
        CustomerFilter filter = new CustomerFilter();
        List<Customer> customerList = null;
        try {
            //public CustomerCountry(String customerCountryId, String customerCountryName,
            //        String customerCountryIsoCode, Date dateCreated,
            //        Date lastModified) {
            filter.setDeliveryCountry(new Country("-70", "UNITED KINGDOM", "GB", null, null));
            customerList = crm.queryCustomers(filter);
            assertEquals(4, customerList.size());
            filter = new CustomerFilter();
            filter.setInvoiceCountry(new Country("-221", "GERMANY", "DE", null, null));
            customerList = crm.queryCustomers(filter);
            assertEquals(11, customerList.size());
            customerList.get(0).hashCode();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * tests filter attribute customerCountry, especially the customerCountry
     * attribute customerCountryName with method setCustomerCountryByName()
     */
    @Test
    public void testCustomerCountryByName() {
        CustomerFilter filter = new CustomerFilter();
        List<Customer> customerList = null;
        try {
            filter.setDeliveryCountryByName("FRANCE");
            customerList = crm.queryCustomers(filter);
            assertEquals(4, customerList.size());
            filter = new CustomerFilter();
            filter.setInvoiceCountryByName("GERMANY");
            customerList = crm.queryCustomers(filter);
            assertEquals(11, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * tests filter attribute customerCountry, especially the customerCountry
     * attribute customerCountryIsoCode with method setCustomerCountryByIsoCode()
     */
    @Test
    public void testCustomerCountryByIsoCode() {
        CustomerFilter filter = new CustomerFilter();
        filter.setDeliveryCountryByIsoCode("DE");
        List<Customer> customerList = null;
        try {
            customerList = crm.queryCustomers(filter);
            assertEquals(11, customerList.size());
            filter = new CustomerFilter();
            filter.setInvoiceCountryByIsoCode("FR");
            customerList = crm.queryCustomers(filter);
            assertEquals(4, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

}
