/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerCategory;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * tests 3 ways to set the category filter,
 * success is verified by checking the list returned from the database 
 * @author Claudius Haecker
 */
public class CRMManagerFilterCategoryTest {

    private static final Logger LOG = Logger.getLogger(CRMManagerFilterCategoryTest.class);
    private static final CRMManager CRM_MANAGER = ServiceLocator.getInstance().getCRMManager();

    /**
     * The setUp method is called once before running the test.
     * It gets an CRMManager instance (crm) that is used in the
     * different test methods.
     */
    @BeforeClass
    public static void setUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: setUp");
        }
    }

    /**
     * Tests that the CRMManager crm instanciated in the setUp method
     * is not null.
     */
    @Test
    public void testGetCRM() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - called: testGetCRM");
        }
        assertNotNull(CRM_MANAGER);
    }

    @Test
    public void testCategory() {
        CustomerFilter filter = new CustomerFilter();
        List<Customer> customerList = null;
        try {
            filter.setCategory(new CustomerCategory("-2", "important customer", "B", null, null));
            customerList = CRM_MANAGER.queryCustomers(filter);
            assertEquals(5, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * tests filter attribute customerCategory, especially the customerCategory
     * attribute customerCategoryName with method setCustomerCategoryByName()
     */
    @Test
    public void testCustomerCategoryByName() {
        CustomerFilter filter = new CustomerFilter();
        filter.setCustomerCategoryByName("business critical customer");
        List<Customer> customerList = null;
        try {
            customerList = CRM_MANAGER.queryCustomers(filter);
            assertEquals(4, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
        filter.setCustomerCategoryByName("customer");
        try {
            customerList = CRM_MANAGER.queryCustomers(filter);
            assertEquals(19, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * tests filter attribute customerCategory, especially the customerCategory
     * attribute customerCategoryKey with method setCustomerCategoryByKey()
     */
    @Test
    public void testCustomerCategoryByKey() {
        CustomerFilter filter = new CustomerFilter();
        filter.setCustomerCategoryByKey("C");
        List<Customer> customerList = null;
        try {
            customerList = CRM_MANAGER.queryCustomers(filter);
            assertEquals(10, customerList.size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
    }

}
