/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.service;

import java.util.List;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Country;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerCategory;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * 
 * @author Claudius Haecker
 *
 */
public interface CRMManager {

    public List<Country> getCountries() throws ApplicationException;

    public List<CustomerType> getCustomerTypes() throws ApplicationException;

    public List<CustomerCategory> getCustomerCategories() throws ApplicationException;

//    public List<Customer> queryCustomers(String namePattern, String numberPattern, CustomerCategory category,
//            CustomerType type, Country country) throws ApplicationException;

    public List<Customer> queryCustomers(CustomerFilter filter) throws ApplicationException;

}
