/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.domain;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Each object of this class holds one of the possible invoice 
 * or delivery countries of customers.
 * @author Claudius Haecker
 */
@Entity
@Table(name = "country")
public class Country implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1577944261439810380L;
    private String countryId;
    private String name;
    private String isoCode;
    private Date dateCreated;
    private Date dateLastModified;

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "country_id", nullable = false)
    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    @Column(name = "name", nullable = false)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <a href=" http://www.iso.org/iso/country_codes/iso_3166_code_lists/english_country_names_and_code_elements.htm">ISO 3166-1-alpha-2 code</a>
     * @return ISO 3166-1-alpha-2 code
     */
    @Column(name = "iso_code", length = 2, nullable = false)
    public String getIsoCode() {
        if (isoCode == null) {
            isoCode = "";
        }
        return isoCode;
    }

    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Column(name = "last_modified", nullable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    /**
     * @param countryId primary key
     * @param name country name
     * @param isoCode see <a href="list-en1-semic-3.txt">ISO 3166 code list - txt. semicolon limited</a>, 5 k
     * @param dateCreated the date set by the database on each row when <code>this</code> was inserted into the database.
     * @param dateLastModified the date (as set by the database) when <code>this</code> was updated in the database the last time.
     */
    public Country(String countryId, String name, String isoCode, Date dateCreated, Date dateLastModified) {
        this.countryId = countryId;
        this.name = name;
        this.isoCode = isoCode;
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
    }

    /**
     * default constructor
     */
    public Country() {
    }

    /**
     * determines equality by the iso code of the country
     * @param obj the country to compare to
     * @return whether both countries are equal 
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Country) {
            Country o = (Country) obj;
            return this.isoCode.equals(o.getIsoCode());
        } else {
            return false;
        }
    }

    @Override
    /**
     * If two objects are equal according to the equals(Object) method, then
     * calling the hashCode method on each of the two objects must produce the
     * same integer result. (From Java� Platform Standard Ed. 6 JavaDoc)
     * 
     */
    public int hashCode() {
        return this.getIsoCode().hashCode();
    }
}
