/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;

/**
 * This class is needed to get all types customers can be categorized in. 
 * @author Claudius Haecker
 *
 */
public class CustomerTypeDaoImpl extends HibernateDaoSupport implements CustomerTypeDao {

    private static final Logger LOG = Logger.getLogger(CustomerTypeDaoImpl.class);

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.crm_simulator.be.dao.CustomerTypeDao#getCustomerTypes()
     */
    public List<CustomerType> getCustomerTypes() throws DaoException {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug(">> getCustomerTypes");
        }
        List<CustomerType> customerTypes;
        try {
            // DB-Query
            // execute query and receive result
            customerTypes = getHibernateTemplate().find("from CustomerType");
        } catch (DataAccessException e) {
            LOG.error(e);
            throw new DaoException(e);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCustomerTypes", start, stop);
        }
        
        return customerTypes;
    }
}
