/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;

/**
 * This interface is needed to get all types customers can be categorized in. 
 * @author Claudius Haecker
 *
 */
public interface CustomerTypeDao {

    /**
     * @return all types customers can be categorized in
     * @throws DaoException if database problems occur
     */
    public List<CustomerType> getCustomerTypes() throws DaoException;

}
