/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * This interface is needed to query customers.
 * 
 * @author Claudius Haecker
 * @author braeuninger
 *
 */
public interface CustomerDao {

    /**
     * retrieves a List of customers that match given filter criteria.
     * @param filter the criteria
     * @return a list of Customers that match the criterions in the filter object 
     * @throws DaoException if database problems occur
     */
    public List<Customer> queryCustomers(CustomerFilter filter) throws DaoException;

}
