/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerCategory;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;

/**
 * This class is needed to get all categories customers can be ranked in. 
 * @author Claudius Haecker
 *
 */
public class CustomerCategoryDaoImpl extends HibernateDaoSupport implements CustomerCategoryDao {

    private static final Logger LOG = Logger.getLogger(CustomerCategoryDaoImpl.class);

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.crm_simulator.be.dao.CustomerCategoryDao#getCustomerCategories()
     */
    public List<CustomerCategory> getCustomerCategories() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getCustomerCategories");
        }

        try {
            return getHibernateTemplate().find("from CustomerCategory");
        } catch (DataAccessException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw new DaoException(e);
        }
    }
}
