/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.crm_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.Country;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;

/**
 * This class is needed to get all possible invoice or delivery countries of customers.
 * @author Claudius Haecker
 *
 */
public class CountriesDaoImpl extends HibernateDaoSupport implements CountriesDao {

    private static final Logger LOG = Logger.getLogger(CountriesDaoImpl.class);

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.crm_simulator.dao.CountriesDao#getCountries()
     */
    /**
     * @return all countries available for filtering
     * @throws DaoException if data access produces errors
     */
    public List<Country> getCountries() throws DaoException {
       
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug(">> getCountries");
        }
        List<Country> countries;
        try {
            // DB-Query
            // execute query and receive result
            countries = getHibernateTemplate().find("from Country ORDER BY name ASC");
        } catch (DataAccessException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw new DaoException(e);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getCountries", start, stop);
        }
        return countries;
    }
}
